<aside class="main-sidebar sidebar-dark-primary elevation-4">

    <a href="{{route('home')}}" class="brand-link text-center">
        <img src="{{asset('logos/icono.jpg')}}" alt="AdminLTE Logo" class="brand-image elevation-3" style="opacity: .8">
        <!-- <span class="brand-text font-weight-light"> <i class="fa fa-home" aria-hidden="true"></i> {{config('app.name')}}</span> -->
    </a>
    <div class="sidebar">

        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="https://ui-avatars.com/api/?name={{Auth::user()->name}}" alt="{{config('app.name')}}" class="img-circle elevation-2">
            </div>
            <div class="info" style="color: white;">
                {{Auth::user()->name}} <br> {{ Auth::user()->role->title }}
            </div>
        </div>

        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">

                <li class="nav-header">MENU</li>

                <li class="nav-item">
                    <a href="{{route('home')}}" aria-expanded="false" class="nav-link">
                        <i class="fa fa-home" aria-hidden="true"></i>
                        <p class="nav-text">CASA</p>
                    </a>
                </li>

                @can('agenda_all')
                <li class="nav-item">
                    <a href="{{ route('agenda.index') }}" class="nav-link">
                        <i class="fa fa-calendar" aria-hidden="true"></i>
                        <span class="sub-item">AGENDA</span>
                    </a>
                </li>
                @endcan

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-sticky-note" aria-hidden="true"></i>
                        <p>
                            Recetas
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('receta.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Registro de Recetas</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('receta.recetar') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Recetar a Pacientes</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-header">PACIENTES</li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-user-plus" aria-hidden="true"></i>
                        <p>
                            Pacientes
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('paciente_listado')
                        <li class="nav-item">
                            <a href="{{ route('pacientes.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Listado</p>
                            </a>
                        </li>
                        @endcan
                        @can('paciente_store')
                        <li class="nav-item">
                            <a target="_blank" href="{{ route('pacientes.registroTablet') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Registro de Pacientes</p>
                            </a>
                        </li>
                        @endcan

                        @can('paciente_deudores')
                        <li class="nav-item">
                            <a href="{{ route('pacientes.deudores') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Deudores</p>
                            </a>
                        </li>
                        @endcan
                        @can('paciente_listado')
                        <li class="nav-item">
                            <a href="{{ route('pacientes.activos') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Pacientes Activos</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('pacientes.inactivos') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Pacientes Inactivos</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('pacientes.abono_dia') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Abonos</p>
                            </a>
                        </li>


                        @endcan
                        @can('paciente_report')
                        <li class="nav-item">
                            <a href="{{ route('pacientes.reportes') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-user-md"></i>
                        <p>
                            Doctores
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a href="{{ route('doctores.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Listado</p>
                            </a>
                        </li>

                        @can('doctor_store')
                        <li class="nav-item">
                            <a target="_blank" href="{{ route('doctores.create') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Registro de Doctores</p>
                            </a>
                        </li>
                        @endcan

                        @can('doctor_reportes')
                        <li class="nav-item">
                            <a href="{{ route('doctores.reportes') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>


                <li class="nav-item ">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-tooth    "></i>
                        <p>
                            ORTODONCIA
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a href="{{ route('orto.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Listado</p>
                            </a>
                        </li>



                        <li class="nav-item">
                            <a href="{{ route('orto.reportes') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Reportes</p>
                            </a>
                        </li>

                    </ul>
                </li>


                <li class="nav-header">MEDICAMENTOS</li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-chalkboard-teacher    "></i>
                        <p>
                            Proveedores
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can(['proveedor_list', 'proveedor_all' ])
                        <li class="nav-item">
                            <a href="{{ route('prove.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Listado</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a target="_blank" href="{{route('prove.create')}}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Registro</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="{{ route('prove.reporte') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-item d-none">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-map" aria-hidden="true"></i>
                        <p>
                            Facturas
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('pagosfactura_listado')
                        <li class="nav-item">
                            <a href="{{ route('pago-facturas.index') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Listado</p>
                            </a>
                        </li>
                        @endcan
                        @can('pagosfactura_report')
                        <li class="nav-item">
                            <a href="{{ route('pago-facturas.reporte') }}" class="nav-link">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-item d-none">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-tags" aria-hidden="true"></i>
                        <p>
                            Categorías
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('categoria_list')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('categoria.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Listado
                                </p>
                            </a>
                        </li>
                        @endcan

                        @can('categoria_create')
                        <li class="nav-item">
                            <a class=" nav-link" href="{{route('categoria.create')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Categorías
                                </p>
                            </a>
                        </li>
                        @endcan

                        @can('categoria_report')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('categoria.reporte')}}" target="_blank">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes
                                </p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>


                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-medkit" aria-hidden="true"></i>
                        <p>
                            Medicamentos
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('medicamento_listado')
                        <li class="">
                            <a class="nav-link" href="{{route('articulo.index')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Artículos</p>
                            </a>
                        </li>
                        @endcan

                        @can('medicamento_show')
                        <li class="">
                            <a class="nav-link" href="{{route('articulo.updateDB')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Artículos DB</p>
                            </a>
                        </li>
                        @endcan

                        @can('medicamento_store')
                        <li class="nav-item">
                            <a class="nav-link " href="{{route('articulo.nuevo')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Articulo</p>
                            </a>
                        </li>
                        @endcan

                        @can('medicamento_min_stock')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('articulo.stock')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Control de Stock</p>
                            </a>
                        </li>
                        @endcan





                        @can('medicamento_compra_store')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('articulo.comprar')}}" aria-expanded="false">

                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Comprar Articulo</p>
                            </a>
                        </li>
                        @endcan

                        @can('medicamento_historial')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('articulo.comprarHisto')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Historial de Compras</p>
                            </a>
                        </li>
                        @endcan

                        @can('medicamento_report_all')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('articulo.repotes')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-cart-plus" aria-hidden="true"></i>
                        <p>
                            Ventas
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('venta_inicio')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('venta.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Ventas</p>
                            </a>
                        </li>
                        @endcan

                        @can('venta_historial')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('venta.historial')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Historial de Ventas</p>
                            </a>
                        </li>
                        @endcan

                        @can('venta_reports')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('venta.reportes')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-header">CLINICA</li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-tags" aria-hidden="true"></i>
                        <p>
                            Tratamientos
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        @can('tratamiento_listado')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('tratamiento.index')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Tratamientos</p>
                            </a>
                        </li>
                        @endcan

                        @can('tratamiento_store')
                        <li class="nav-item">
                            <a class="nav-link " href="{{route('tratamiento.create')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Tratamiento</p>
                            </a>
                        </li>
                        @endcan

                        @canany(['pagodoctor_listado', 'pagodoctor_store'])

                        @can('pagodoctor_listado')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('pagos.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Porcentaje</p>
                            </a>
                        </li>
                        @endcan

                        @can('pagodoctor_store')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('pagos.create')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Porcentaje</p>
                            </a>
                        </li>
                        @endcan

                        @endcanany

                        @canany(['pagodoctor_report', 'tratamiento_report' ])
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('tratamientos.reportes')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reporte</p>
                            </a>
                        </li>
                        @endcanany
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-cash-register"></i>
                        <p>
                            Caja
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja-secundaria.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item"> Caja Secundaria</p>
                            </a>
                        </li>



                        <li class="nav-item">
                            <a class="nav-link" href="{{route('soli.index')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Solicitud de Compras</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja.entradas')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item"> Caja Chica</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja.salidas')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Gastos</p>
                            </a>
                        </li>
                        @can('caja_cuadre')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja.cuadre')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Cuadre De Caja</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja.cuadre_medicamentos')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Cuadre De Medicamento</p>
                            </a>
                        </li>

                        <li class="nav-item d-none">
                            <a class="nav-link" href="{{route('caja.cuadreOrto')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Cuadre De Ortodoncia</p>
                            </a>
                        </li>


                        @endcan

                        @canany(['caja_filtrado_cajachica','caja_filtrado_gastos', 'caja_movimientos_filtrados', 'caja_movimientos_dia'])
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('caja.movimientos')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes</p>
                            </a>
                        </li>
                        @endcanany
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-chair"></i>
                        <p>
                            Mobiliario
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        @can('mobiliario_listado')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('mobiliario-y-equipo.index')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Mobiliario</p>
                            </a>
                        </li>
                        @endcan

                        @can('mobiliario_store')
                        <li class="nav-item">
                            <a class="nav-link " href="{{route('mobiliario-y-equipo.create')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Mobiliario</p>
                            </a>
                        </li>
                        @endcan

                        @can('mobiliario_report')
                        <li class="nav-item">
                            <a class="nav-link" target="_blank" href="{{route('mobiliario.reporte')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reporte</p>
                            </a>
                        </li>
                        @endcan
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-syringe"></i>
                        <p>
                            Insumos
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        @can('insumo_list')
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('insumos.index')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Insumos</p>
                            </a>
                        </li>
                        @endcan

                        @can('insumo_store')
                        <li class="nav-item">
                            <a class="nav-link " href="{{route('insumos.create')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Insumo</p>
                            </a>
                        </li>
                        @endcan

                        @canany(['insumo_salidas', 'insumo_salidaStore'])
                        <li class="nav-item">
                            <a class="nav-link " href="{{route('insumos.salidas')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Salida de Insumos</p>
                            </a>
                        </li>
                        @endcanany

                        @canany(['insumo_allreport', 'insumo_salidasreport'])
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('insumos.reportPrints')}}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reporte</p>
                            </a>
                        </li>
                        @endcanany
                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-clinic-medical"></i>
                        <p>
                            Laboratorio
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('lab.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Laboratorios</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('lab.create')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registrar Laboratorio</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('lab.reportes')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes de Laboratorio</p>
                            </a>
                        </li>

                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-chart-pie"></i>
                        <p>
                            Gráficas
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('graficas.tratamientos')}}" target="_blank">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Tratamientos</p>

                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('graficas.insumos')}}" target="_blank">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Insumos</p>

                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('graficas.caja')}}" target="_blank">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Meses</p>

                            </a>
                        </li>

                    </ul>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fa fa-clipboard" aria-hidden="true"></i>
                        <p>
                            Recordatorio General
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('reco.index')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Recordatorios</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link" href="{{route('reco.create')}}">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Registro</p>
                            </a>
                        </li>

                    </ul>
                </li>


                @canany(['users_access','roles_access','permissions_access'])
                <li class="nav-item">
                    <a href="#" class="nav-link active ">
                        <i class="fas fa-user-nurse"></i>
                        <p>
                            Usuarios
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">

                        @can('users_access')
                        <li class="nav-item">
                            <a class="nav-link  @if(request()->is('/users') || request()->is('/users/*')) is_active @endif" href="{{ route('users.index') }}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Users</p>
                            </a>
                        </li>
                        @endcan

                        @can('roles_access')
                        <li class="nav-item">
                            <a class="nav-link  @if(request()->is('/roles') || request()->is('/roles/*')) is_active @endif" href="{{ route('roles.index') }}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Roles</p>
                            </a>
                        </li>
                        @endcan

                        @can('permissions_access')
                        <li class="nav-item">
                            <a class="nav-link  @if(request()->is('/permissions') || request()->is('/permissions/*')) is_active @endif" href="{{ route('permissions.index') }}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Permissions</p>
                            </a>
                        </li>
                        @endcan

                        @can('usuario_actividades')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('users.actividades') }}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Actividades</p>
                            </a>
                        </li>
                        @endcan

                        @can('users_userReport')
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('users.userReport') }}" aria-expanded="false">
                                <i class="far fa-circle nav-icon"></i>
                                <p class="sub-item">Reportes</p>
                            </a>
                        </li>
                        @endcan

                    </ul>
                </li>
                @endcanany



            </ul>
        </nav>

    </div>

</aside>