<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clínica - Panel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    @yield('styles')

    <style>
        body {
            background-color: #f4f6f9;
        }

        /* Sidebar Styles */
        .sidebar {
            min-height: 100vh;
            width: 250px;
            background: #343a40;
            /* Color oscuro admin clásico */
            color: #fff;
            position: fixed;
            transition: all 0.3s;
            z-index: 999;
        }

        .sidebar a {
            color: #c2c7d0;
            text-decoration: none;
            padding: 12px 20px;
            display: block;
            border-left: 3px solid transparent;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background: #495057;
            color: #fff;
            border-left-color: #0d6efd;
            /* Azul Bootstrap */
        }

        .content {
            margin-left: 250px;
            /* Mismo ancho que sidebar */
            padding: 20px;
            transition: all 0.3s;
        }

        /* Responsive para móvil */
        @media (max-width: 768px) {
            .sidebar {
                margin-left: -250px;
            }

            .sidebar.active {
                margin-left: 0;
            }

            .content {
                margin-left: 0;
            }
        }

        /* Corrección del conflicto Bootstrap 5 Placeholder vs SlimSelect */
        .ss-main .ss-single-selected .placeholder {
            background-color: transparent !important;
            /* Quita el fondo gris de 'carga' */
            opacity: 1 !important;
            /* Devuelve la visibilidad al 100% */
            cursor: pointer !important;
            /* Quita el cursor de 'reloj/wait' */
            min-height: auto !important;
            /* Quita la altura forzada del skeleton */
            display: block !important;
            /* Asegura comportamiento normal */
        }

        /* Opcional: Asegurar color del texto si aún se ve gris claro */
        .ss-main .ss-single-selected .placeholder * {
            color: #697a8d;
            /* O el color de texto de tu tema */
        }
    </style>
</head>

<body>

    <div class="sidebar d-flex flex-column p-3" id="sidebar">
        <a href="{{ route('doc.home') }}" class="d-flex align-items-center mb-3 mb-md-0 me-md-auto text-white text-decoration-none">
            <span class="fs-4 fw-bold"><i class="fa fa-heartbeat text-primary"></i> {{config('app.name')}}</span>
        </a>
        <hr>
        <ul class="nav nav-pills flex-column mb-auto">
            <li>
                <a href="{{ route('doc.home') }}" class="active"><i class="fa fa-home me-2"></i> Dashboard</a>
            </li>
            <li>
                <a href="{{ route('doc.pacientesHoy') }}"><i class="fa fa-users me-2"></i> Pacientes</a>
            </li>
            <li>
                <a href="{{ route('doc.reportes') }}"><i class="fa fa-shopping-cart me-2"></i> Reportes</a>
            </li>
        </ul>
        <hr>
        <div class="dropdown">
            <a href="#" class="d-flex align-items-center text-white text-decoration-none dropdown-toggle" id="dropdownUser1" data-bs-toggle="dropdown" aria-expanded="false">
                <img src="https://ui-avatars.com/api/?name={{ session()->get('doctor')['nombre'] }}" alt="" width="32" height="32" class="rounded-circle me-2">
                <strong>Dr. {{ session()->get('doctor')['nombre'] }}</strong>
            </a>
            <ul class="dropdown-menu dropdown-menu-dark text-small shadow" aria-labelledby="dropdownUser1">
                <li><a class="dropdown-item" href="#">Perfil</a></li>
                <li>
                    <hr class="dropdown-divider">
                </li>
                <li><a class="dropdown-item" href="#">Cerrar Sesión</a></li>
            </ul>
        </div>
    </div>

    <div class="content">
        <nav class="navbar navbar-light bg-white shadow-sm mb-4 rounded d-md-none">
            <div class="container-fluid">
                <button class="btn btn-primary" id="sidebarToggle"><i class="fa fa-bars"></i></button>
                <span class="navbar-brand mb-0 h1">{{config('app.name')}}</span>
            </div>
        </nav>

        @yield('content')
    </div>



    <footer class="py-5">
        <div class="container">
            <p class="m-0 text-center text-muted">&copy; <?php echo date('Y'); ?> DeCoDev. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Toggle Sidebar en Móvil
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });
    </script>

    @yield('scripts')
</body>

</html>