<!DOCTYPE html>
<html dir="ltr" lang="es">

<head>

   <title>{{config('app.name')}}</title>
   <meta charset="utf-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="description" content="Sobre Nosotros">
   <meta name="keywords" content="Dientes, Dentista, Boca, Clinica, Quetzaltenango, clinica Quetzaltenango, Xela, clinica">
   <meta name="author" content="DeCoDev Desarrollo de Software">
   <link rel="icon" href="{{asset('logos/ico.ico')}}" type="image/x-icon">

   <link rel="stylesheet" href="{{asset('plugins/bootstrap/bootstrap.min.css')}}">

   <script src="{{asset('plugins/fontaweson/fontaws.js')}}"></script>

   <link rel="stylesheet" href="{{asset('styles.css')}}">

   <style>
      @media print {

         .oculto-impresion,
         .oculto-impresion * {
            display: none !important;
         }



         h5 {
            font-size: 10px;
            padding: 5px;
         }
      }
   </style>

   @yield('styles')
</head>

<body style="background: white;" style="text-transform: uppercase;">

   @include('includes.alerts')

   @yield('more')

   <div class="row justify-content-center  py-3 titulo123">
      <div class="col-md-5 text-center">
         <img class="rounded shadow-sm" style="width: 25%;" src="{{asset('logos/icono.jpg')}}" alt="{{config('app.name')}}">
      </div>
      <div class="col-md-5 text-center">
         <p>
            <b>ODONTOLOGÍA GENERAL</b> <br>
            {{config('app.direccion')}} <br>
            Tel. {{config('app.telefono')}} Email: {{config('app.email')}}
         </p>
      </div>
   </div>

   <div class="container-fluid">
      <div class="row">
         <div class="col-md-12">
            @yield('content')
         </div>
      </div>
   </div>


   <script src="{{asset('plugins/bootstrap/jquery.min.js')}}"></script>
   <script src="{{asset('plugins/bootstrap/popper.min.js')}}"></script>
   <script src="{{asset('plugins/bootstrap/bootstrap.min.js')}}"></script>


   @yield('scripts')
</body>

</html>