@extends('layouts.doctor')

@section('styles')
<link rel="stylesheet" href="{{ asset('plugins/slim-select/slimselect.min.css') }}">
<link href="https://cdn.jsdelivr.net/npm/sweetalert2@11.11.1/dist/sweetalert2.min.css" rel="stylesheet">
<style>
    /* Estilo para el botón flotante (FAB) en móvil */
    .fab-container {
        position: fixed;
        bottom: 20px;
        right: 20px;
        z-index: 999;
    }

    .fab-btn {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
    }

    /* Ajustes para inputs en móvil */
    .form-control,
    .form-select {
        font-size: 16px;
        /* Evita zoom en iOS */
        padding: 10px;
    }

    /* Avatar */
    .avatar-profile {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border: 3px solid #fff;
        box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }
</style>
@endsection

@section('content')

{{-- 1. PERFIL COMPACTO --}}
<div class="container-fluid mt-3 mb-4">
    <div class="card border-0 shadow-sm rounded-4 bg-primary text-white">
        <div class="card-body d-flex align-items-center p-3">

            @if ($paciente->foto_perfil == null)
            <img width="150" src="https://ui-avatars.com/api/?name={{ $paciente->nombre }}"
                class="rounded-circle avatar-profile me-3" alt="{{ config('app.name') }}" srcset="">
            @else
            <img width="150" src="{{ asset('storage/' . 'pacientes/fotos/' .$paciente->foto_perfil) }}"
                class="rounded-circle avatar-profile me-3 " alt="{{ config('app.name') }}" srcset="">
            @endif


            <div>
                <h5 class="mb-0 fw-bold text-white">{{ $paciente->nombre }}</h5>
                <!-- <p class="mb-0 opacity-75"><i class="fas fa-phone-alt me-1"></i> {{ $paciente->telefono }}</p> -->
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <ul class="list-group list-group-numbered">
                @foreach ($recordatorios as $recordatorio => $item)
                <li class="list-group-item"> {{$item->descripcion}}</li>
                @endforeach
            </ul>

        </div>
    </div>
</div>


<div class="container-fluid mb-5 pb-5"> @if ($errors->any())
    <div class="alert alert-danger shadow-sm rounded-3">
        <ul class="mb-0 ps-3">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- 2. TRATAMIENTOS A REALIZAR (ACORDEÓN) --}}


    {{-- BOTÓN PRINCIPAL "CAMBIOS" (Abre el Wizard) --}}
    <div class="fixed-bottom p-3 d-flex justify-content-end pointer-events-none">
        <button type="button" class="btn btn-primary btn-lg shadow-lg rounded-pill px-4 py-3 pointer-events-auto" data-bs-toggle="modal" data-bs-target="#modalWizard">
            <i class="fas fa-edit me-2"></i> CAMBIOS / ATENCIÓN
        </button>
    </div>

    {{-- MODAL WIZARD (4 PASOS) --}}
    <div class="modal fade" id="modalWizard" tabindex="-1" data-bs-backdrop="static" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 shadow">

                {{-- HEADER: BARRA DE PROGRESO --}}
                <div class="modal-header bg-light pb-0 border-0">
                    <div class="w-100">
                        <div class="d-flex justify-content-between mb-2 px-2">
                            <small class="fw-bold text-primary step-label">1. Tratamientos</small>
                            <small class="fw-bold text-muted step-label">2. Diario</small>
                            <small class="fw-bold text-muted step-label">3. Recordatorios</small>
                            <small class="fw-bold text-muted step-label">4. Resumen</small>
                        </div>
                        <div class="progress" style="height: 5px;">
                            <div class="progress-bar bg-primary" id="progressBar" role="progressbar" style="width: 25%"></div>
                        </div>
                    </div>
                    <button type="button" class="btn-close ms-3 align-self-start" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                {{-- FORMULARIO GLOBAL --}}
                <form id="formAtencion" action="{{ route('doc.paciente-setPagosHistorialAndMore') }}" method="post">
                    @csrf
                    <input type="hidden" name="paciente_id" value="{{ $paciente->id }}">
                    <input type="hidden" name="doctor_id" value="{{ session()->get('doctor')['id'] }}">

                    <div class="modal-body p-4">

                        {{-- PASO 1: TRATAMIENTOS Y ASISTENTE --}}
                        <div class="step-content" id="step1">
                            <h5 class="fw-bold text-primary mb-3"><i class="fas fa-tooth me-2"></i>Seleccionar Tratamientos Realizados</h5>

                            @if(count($procedimientos) > 0)
                            <div class="list-group mb-4 shadow-sm">
                                @foreach ($procedimientos as $p)
                                <label class="list-group-item d-flex gap-3 align-items-center p-3">
                                    <input class="form-check-input flex-shrink-0" type="checkbox" name="procedimientos_ids[]" value="{{ $p->id }}" style="font-size: 1.3em;" data-nombre="{{ $p->tratamiento->nombre }}">
                                    <div class="d-flex flex-column">
                                        <span class="fw-bold text-dark">{{ $p->tratamiento->nombre }}</span>
                                        <small class="text-muted">Pieza: {{ $p->pieza }} | {{ $p->tratamiento->descripcion }}</small>
                                    </div>
                                </label>
                                @endforeach
                            </div>
                            @else
                            <div class="alert alert-warning">No hay tratamientos pendientes en la hoja actual.</div>
                            @endif

                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted small">Asistente en esta sesión</label>
                                <select name="asistente" id="asistenteGlobal" class="form-control form-control-lg" required>
                                    <option value="">Seleccione Asistente</option>
                                    @foreach ($users as $a)
                                    <option value="{{ $a->name }}">{{ $a->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        {{-- PASO 2: DIARIO (NOTAS CLINICAS) --}}
                        <div class="step-content d-none" id="step2">
                            <h5 class="fw-bold text-primary mb-3"><i class="fas fa-book-medical me-2"></i>Notas de Diario</h5>

                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted small">Descripción del Procedimiento (Diario)</label>
                                <textarea class="form-control" name="descripcion" id="inputDescripcion" rows="4" placeholder="Detalle lo realizado hoy..."></textarea>
                            </div>
                            <div class="row">
                                <!-- <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold text-muted small">Recomendaciones / Receta</label>
                                    <textarea class="form-control" name="recomendacion" id="inputRecomendacion" rows="2"></textarea>
                                </div> -->
                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold text-muted small">Próxima Cita (Indicación)</label>
                                    <input type="text" class="form-control" name="proxima" id="inputProxima" placeholder="Ej: En 15 días para retiro de puntos">
                                </div>
                            </div>
                        </div>

                        {{-- PASO 3: RECORDATORIOS --}}
                        <div class="step-content d-none" id="step3">
                            <h5 class="fw-bold text-primary mb-3"><i class="fas fa-bell me-2"></i>Recordatorios al Paciente</h5>

                            <div class="card bg-light border-0 p-3 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="checkRecordatorio" name="enviar_recordatorio" value="1" checked>
                                    <label class="form-check-label fw-bold" for="checkRecordatorio">Enviar recordatorio de próxima cita</label>
                                </div>
                            </div>

                            <div id="divRecordatorioOpciones">
                                <div class="mb-3">
                                    <label class="form-label small text-muted">Medio de envío</label>
                                    <div class="btn-group w-100" role="group">
                                        <input type="radio" class="btn-check" name="medio_recordatorio" id="btnradio1" value="whatsapp" checked>
                                        <label class="btn btn-outline-success" for="btnradio1"><i class="fab fa-whatsapp"></i> WhatsApp</label>

                                        <input type="radio" class="btn-check" name="medio_recordatorio" id="btnradio2" value="email">
                                        <label class="btn btn-outline-secondary" for="btnradio2"><i class="far fa-envelope"></i> Email</label>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label small text-muted">Mensaje personalizado (Opcional)</label>
                                    <textarea class="form-control" name="mensaje_recordatorio" rows="2" placeholder="Hola {{ $paciente->nombre }}, recuerda..."></textarea>
                                </div>
                            </div>
                        </div>

                        {{-- PASO 4: RESUMEN --}}
                        <div class="step-content d-none" id="step4">
                            <h5 class="fw-bold text-primary mb-3"><i class="fas fa-clipboard-check me-2"></i>Resumen de Cambios</h5>

                            <div class="card border-0 shadow-sm bg-light">
                                <div class="card-body">
                                    <h6 class="fw-bold small text-uppercase text-muted">Tratamientos a Marcar:</h6>
                                    <ul class="mb-3 ps-3" id="resumenTratamientos">
                                    </ul>

                                    <h6 class="fw-bold small text-uppercase text-muted">Asistente:</h6>
                                    <p class="mb-3" id="resumenAsistente">--</p>

                                    <h6 class="fw-bold small text-uppercase text-muted">Nota de Diario:</h6>
                                    <p class="mb-0 fst-italic text-secondary" id="resumenNota">--</p>
                                </div>
                            </div>

                            <div class="alert alert-info mt-3 d-flex align-items-center">
                                <i class="fas fa-info-circle fa-2x me-3"></i>
                                <div>
                                    <small>Al confirmar, se guardarán los tratamientos, se creará el registro en el diario y se programará el recordatorio.</small>
                                </div>
                            </div>
                        </div>

                    </div>

                    {{-- FOOTER: BOTONES DE NAVEGACIÓN --}}
                    <div class="modal-footer border-0 pt-0 justify-content-between">
                        <button type="button" class="btn btn-light" id="btnPrev" style="display:none;">
                            <i class="fas fa-arrow-left me-2"></i> Atrás
                        </button>

                        <button type="button" class="btn btn-primary px-4" id="btnNext">
                            Siguiente <i class="fas fa-arrow-right ms-2"></i>
                        </button>

                        <button type="submit" class="btn btn-success px-4" id="btnFinish" style="display:none;" onclick="return confirm('¿Confirma guardar todos los cambios?')">
                            <i class="fas fa-save me-2"></i> Finalizar y Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    {{-- 3. HISTORIAL REALIZADO (CARDS) --}}
    <div class="d-flex justify-content-between align-items-center mb-3 mt-4">
        <h6 class="text-uppercase text-muted fw-bold small ls-1">Historial Realizado</h6>
        <small class="text-muted">Dr. {{ session()->get('doctor')['nombre'] }}</small>
    </div>

    <div class="row g-3">
        @forelse ($procedimientos_doc as $p)
        <div class="col-12 col-md-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <h6 class="fw-bold text-primary mb-0">{{ $p->tratamiento->nombre }}</h6>
                        <span class="badge bg-light text-dark border">{{ \Carbon\Carbon::parse($p->fecha)->format('d/m/Y') }}</span>
                    </div>

                    <p class="small text-muted mb-2">
                        {{ $p->tratamiento->descripcion }} ({{ $p->tratamiento->tipo }})
                    </p>

                    @if($p->recomendacion)
                    <div class="alert alert-secondary p-2 mb-2 small">
                        <i class="fas fa-comment-medical me-1"></i> {{ $p->recomendacion }}
                    </div>
                    @endif

                    {{-- Collapse para Diario dentro del historial --}}
                    @php $diarios = getDairioToFecha($p->paciente_id, $p->fecha); @endphp

                    @if(count($diarios) > 0)
                    <button class="btn btn-sm btn-outline-info w-100 mt-2" type="button" data-bs-toggle="collapse" data-bs-target="#historialDiario{{$p->id}}">
                        <i class="fas fa-book-medical me-1"></i> Ver Notas Diario
                    </button>
                    <div class="collapse mt-2" id="historialDiario{{$p->id}}">
                        <div class="card card-body bg-light p-2 small border-0">
                            @foreach ($diarios as $diario)
                            <div class="mb-2 border-bottom pb-2">
                                <strong>Nota:</strong> {{$diario->descripcion}}<br>
                                <strong>Próxima:</strong> {{$diario->proxima}}
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @empty
        <div class="col-12">
            <div class="text-center text-muted py-3">No has realizado procedimientos hoy.</div>
        </div>
        @endforelse
    </div>

</div>

{{-- 4. BOTÓN FLOTANTE (FAB) PARA DIARIO --}}
<div class="fab-container">
    <button type="button" class="btn btn-success fab-btn text-white" data-bs-toggle="modal" data-bs-target="#diario">
        <i class="fas fa-plus"></i>
    </button>
</div>

<div class="modal fade" id="diario" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title fw-bold">Nuevo Diario</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{route('doc.diario-store')}}" method="post">
                @csrf
                <input type="hidden" name="paciente_id" value="{{$paciente->id}}">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label text-muted small fw-bold">Doctor</label>
                        <input type="text" class="form-control bg-light" value="{{session()->get('doctor')['nombre']}}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label text-muted small fw-bold">Descripción de la Cita</label>
                        <textarea class="form-control" name="descripcion" rows="4" required></textarea>
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label text-muted small fw-bold">Pieza(s)</label>
                            <input type="text" class="form-control" name="piezas">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label text-muted small fw-bold">Próxima Cita</label>
                            <input type="text" class="form-control" name="proxima">
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 pt-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-success px-4">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{ asset('plugins/slim-select/slimselect.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.11.1/dist/sweetalert2.all.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Inicializar SlimSelect para el asistente global
        new SlimSelect({
            select: '#asistenteGlobal',
            placeholder: 'Seleccione Asistente',
            showSearch: false
        });

        // Variables del Wizard
        let currentStep = 1;
        const totalSteps = 4;

        const btnNext = document.getElementById('btnNext');
        const btnPrev = document.getElementById('btnPrev');
        const btnFinish = document.getElementById('btnFinish');
        const progressBar = document.getElementById('progressBar');

        // Manejo del botón Siguiente
        btnNext.addEventListener('click', () => {
            if (!validateStep(currentStep)) return; // Validar antes de avanzar

            if (currentStep < totalSteps) {
                // Ocultar actual
                document.getElementById(`step${currentStep}`).classList.add('d-none');

                // Actualizar contadores
                currentStep++;

                // Mostrar nuevo
                document.getElementById(`step${currentStep}`).classList.remove('d-none');

                updateWizardUI();
            }
        });

        // Manejo del botón Atrás
        btnPrev.addEventListener('click', () => {
            if (currentStep > 1) {
                document.getElementById(`step${currentStep}`).classList.add('d-none');
                currentStep--;
                document.getElementById(`step${currentStep}`).classList.remove('d-none');
                updateWizardUI();
            }
        });

        // Función para actualizar barra, textos y botones
        function updateWizardUI() {
            // 1. Barra de progreso
            const percent = (currentStep / totalSteps) * 100;
            progressBar.style.width = `${percent}%`;

            // 2. Colores de los labels superiores
            const labels = document.querySelectorAll('.step-label');
            labels.forEach((lbl, index) => {
                if (index + 1 === currentStep) {
                    lbl.classList.remove('text-muted');
                    lbl.classList.add('text-primary');
                } else {
                    lbl.classList.add('text-muted');
                    lbl.classList.remove('text-primary');
                }
            });

            // 3. Botones
            btnPrev.style.display = (currentStep === 1) ? 'none' : 'block';

            if (currentStep === totalSteps) {
                btnNext.style.display = 'none';
                btnFinish.style.display = 'block';
                populateSummary(); // Llenar el resumen al llegar al paso 4
            } else {
                btnNext.style.display = 'block';
                btnFinish.style.display = 'none';
            }
        }

        // Validación simple por paso
        function validateStep(step) {
            if (step === 1) {
                // Verificar si hay asistente seleccionado
                const asistente = document.getElementById('asistenteGlobal').value;
                if (!asistente) {
                    Swal.fire('Atención', 'Debe seleccionar un asistente', 'warning');
                    return false;
                }
                // Verificar si hay al menos un tratamiento (opcional, o puede ser solo diario)
                // const checked = document.querySelectorAll('input[name="procedimientos_ids[]"]:checked');
                // if(checked.length === 0 && !confirm("¿No seleccionó tratamientos, solo guardará diario?")) return false;
            }
            if (step === 2) {
                const desc = document.getElementById('inputDescripcion').value;
                if (!desc.trim()) {
                    Swal.fire('Atención', 'La nota de diario es obligatoria', 'warning');
                    return false;
                }
            }
            return true;
        }

        // Llenar el resumen del paso 4
        function populateSummary() {
            // Tratamientos
            const checkboxes = document.querySelectorAll('input[name="procedimientos_ids[]"]:checked');
            const lista = document.getElementById('resumenTratamientos');
            lista.innerHTML = '';

            if (checkboxes.length > 0) {
                checkboxes.forEach(chk => {
                    const li = document.createElement('li');
                    li.textContent = chk.getAttribute('data-nombre');
                    lista.appendChild(li);
                });
            } else {
                lista.innerHTML = '<li class="text-muted">Ninguno seleccionado (Solo nota de diario)</li>';
            }

            // Asistente
            document.getElementById('resumenAsistente').textContent = document.getElementById('asistenteGlobal').value;

            // Nota
            document.getElementById('resumenNota').textContent = document.getElementById('inputDescripcion').value || 'Sin descripción';
        }

        // Toggle recordatorio
        document.getElementById('checkRecordatorio').addEventListener('change', function() {
            const div = document.getElementById('divRecordatorioOpciones');
            if (this.checked) div.classList.remove('d-none');
            else div.classList.add('d-none');
        });
    });
</script>
@endsection