<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{config('app.name')}}</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Karla:ital,wght@0,200..800;1,200..800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');

        body,
        html {
            margin: 0;
            padding: 0;
            height: 100%;
        }

        .container {
            position: relative;
            width: 100%;
            height: 100%;
            overflow: hidden;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .container::before {
            content: "";
            position: absolute;
            width: 100%;
            height: 100%;
            background-image: url('<?php echo asset('logos/fondo.jpg') ?>');
            background-size: cover;
            background-position: center;
            filter: blur(16px);
            z-index: -1;
        }

        .login-container {
            z-index: 1;
            background-color: aliceblue;
            width: 25vw;
            min-width: 320px;
            min-height: 370px;
            border-radius: 24px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .login-container>h1 {
            font-family: 'Karla';
            font-size: 42px;
            color: #1e3932;
            line-height: 50px;
        }

        .form-login {
            width: 90%;
            display: flex;
            flex-direction: column;
            gap: 25px;
            padding: 20px;
        }


        label {
            font-family: 'Karla';
            font-size: 12px;
            line-height: 12px;
            letter-spacing: 0.1em;
            color: #767676;
            cursor: text;
            text-transform: uppercase;
        }

        input {
            background: transparent;
            border: none;
            border-bottom: 1px solid grey;
            width: 100%;
            height: 18px;
        }

        input:focus {
            outline: none;
            /* Remove a borda de foco */
        }

        .forgot-password {
            align-self: flex-end;
            font-size: 16px;
            border-bottom: 1.5px solid #00754a;
            text-decoration: none;
            color: #00754a;
        }

        .text--create-account {
            color: #006241;
            font-family: 'Karla';
        }

        .create-account>a,
        button {
            font-size: 18px;
            letter-spacing: 1px;
            color: black;
            border: 2px solid #ffff;
            text-decoration: none;
            padding: 8px 50px;
            margin: 10px 0;
            border-radius: 50px;
            background-color: #ffd300;
            cursor: pointer;
        }
    </style>
</head>

<body>


    <div class="container">
        @include('sweetalert::alert')
        <div class="login-container">
            <h1>INICIO DE SESION</h1>
            <form action="{{route('doc.login')}}" class="form-login" method="post">
                @csrf
                <div class="textfield">
                    <label for="email">Usuario</label>
                    <input type="text" name="email" placeholder="Usuario Registrado" value="{{old('email')}}">
                </div>
                <div class="textfield " style="display: none;">
                    <label for="senha">Contraseña</label>
                    <input type="password" name="password" placeholder="Cotnraseña">
                </div>

                <button class="btn-login">INICIAR SESION </button>
            </form>
            <div>
            </div>
        </div>
    </div>
</body>

</html>