@extends('layouts.doctor')

@section('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
@section('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<style>
    /* --- BARRA DE BÚSQUEDA FLOTANTE (STICKY) --- */
    .search-bar-container {
        position: sticky;
        top: 0;
        z-index: 100;
        background-color: #f4f6f9;
        /* Color de fondo para tapar lo que pasa por debajo */
        padding: 10px 0 15px 0;
        margin-bottom: 10px;
    }

    /* Input de búsqueda estilizado (Redondo y limpio) */
    div.dataTables_filter {
        text-align: left !important;
        width: 100%;
    }

    div.dataTables_filter label {
        width: 100%;
        font-size: 0;
    }

    /* Ocultar texto "Search" */

    div.dataTables_filter input {
        width: 100% !important;
        margin: 0 !important;
        border-radius: 50px;
        padding: 12px 20px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
        font-size: 1rem;
        background: white;
    }

    div.dataTables_filter input:focus {
        border-color: #3b82f6;
        outline: none;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.2);
    }

    /* --- ARREGLO DE PAGINACIÓN (EL DESFACE) --- */
    .pagination {
        justify-content: center !important;
        flex-wrap: wrap;
        /* Permite que baje de línea si no cabe */
        margin-top: 20px;
        gap: 5px;
        /* Espacio entre botoncitos */
    }

    /* Botones de paginación redondos y pequeños */
    .page-item .page-link {
        border-radius: 50% !important;
        width: 38px;
        height: 38px;
        display: flex;
        align-items: center;
        justify-content: center;
        border: none;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        color: #64748b;
        background: white;
        font-weight: 600;
        margin: 0;
    }

    /* Botón Activo (El azul) */
    .page-item.active .page-link {
        background-color: #3b82f6 !important;
        color: white !important;
        box-shadow: 0 4px 6px rgba(59, 130, 246, 0.3);
    }

    /* Botones deshabilitados (transparentes para que no se vean feos) */
    .page-item.disabled .page-link {
        background-color: transparent !important;
        color: #cbd5e1 !important;
        box-shadow: none;
    }

    /* Ocultar tabla original */
    #tabla_oculta_wrapper #tabla_oculta {
        display: none;
    }
</style>
@endsection

@endsection

@section('content')
<div class="container-fluid p-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="text-primary fw-bold"><i class="fas fa-id-card me-2"></i>Directorio de Pacientes</h2>
            <p class="text-muted mb-0">Gestión de expedientes y hojas de evolución</p>
        </div>
    </div>

    {{-- AQUI SE INYECTARÁN LAS CARDS --}}
    <div id="cards-container" class="row g-3 mb-4">
        {{-- JS llenará esto... --}}
    </div>

    {{-- TABLA "FANTASMA" (Maneja la lógica, búsqueda y paginación) --}}
    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <table id="tabla_oculta" class="table w-100">
                <thead>
                    <tr>
                        <th>Acciones</th>
                        <th>Nombre</th>

                    </tr>
                </thead>
            </table>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function() {
        var table = $('#tabla_oculta').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('doc.pacientes.ajax') }}",
            columns: [{
                    data: 'acciones',
                    name: 'acciones'
                },
                {
                    data: 'nombre',
                    name: 'nombre'
                },

            ],
            language: {
                url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json',
                search: "",
                searchPlaceholder: "🔍 Buscar paciente por nombre..."
            },

            // Configuración para Móvil
            dom: '<"search-bar-container"f>t<"d-flex justify-content-center pb-5"p>',

            pagingType: "simple_numbers",

            // --- CAMBIO AQUÍ: LISTAR DE 5 EN 5 ---
            pageLength: 3,
            // -------------------------------------

            drawCallback: function(settings) {
                var api = this.api();
                var data = api.rows({
                    page: 'current'
                }).data();
                var container = $('#cards-container');

                container.empty();

                if (data.length === 0) {
                    container.html('<div class="col-12 text-center text-muted py-5 mt-5"><h4><i class="fas fa-search me-2"></i>No encontrado</h4></div>');
                    return;
                }

                data.each(function(row, i) {
                    var iniciales = row.nombre.match(/\b(\w)/g);
                    iniciales = (iniciales) ? iniciales.join('').substring(0, 2).toUpperCase() : '??';
                    var direccion = row.direccion ? row.direccion : 'Sin dirección';
                    var telefono = row.telefono ? row.telefono : '';

                    var cardHtml = `
                        <div class="col-12 col-sm-6 col-lg-4">
                            <div class="card patient-card shadow-sm h-100">
                                <div class="card-body p-3">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0 me-3">
                                            <div class="avatar-circle" style="width: 50px; height: 50px; background: #e0f2fe; color: #0369a1; display:flex; align-items:center; justify-content:center; border-radius:50%; font-weight:bold;">
                                                ${iniciales}
                                            </div>
                                        </div>
                                        <div class="flex-grow-1 overflow-hidden">
                                            <h6 class="mb-0 fw-bold text-dark text-truncate">${row.nombre}</h6>
                                            <small class="text-muted text-truncate d-block d-none">
                                                <i class="fa fa-phone" aria-hidden="true"></i> ${telefono}
                                            </small>
                                        </div>
                                    </div>
                                    <hr class="my-3 opacity-10">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="small fw-bold text-primary">Seleccionar Hoja:</span>
                                        <div style="max-width: 160px;">
                                            ${row.acciones}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        `;
                    container.append(cardHtml);
                });
            }
        });
    });
</script>
@endsection