@extends('layouts.doctor')
@section('styles')
<link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet" />
<style>
    :root {
        --fc-border-color: #f0f0f0;
        /* Bordes muy suaves */
        --fc-button-text-color: #555;
        --fc-button-bg-color: #fff;
        --fc-button-border-color: #e2e8f0;
        --fc-button-hover-bg-color: #f8f9fa;
        --fc-button-active-bg-color: #3b82f6;
        /* Azul moderno */
        --fc-button-active-border-color: #3b82f6;
        --fc-today-bg-color: #fff;
    }

    /* Fuente moderna y limpia */
    #calendar {
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        background: #ffffff;
        padding: 20px;
        border-radius: 12px;
        /* Bordes redondeados del contenedor */
    }




    .fc-button:hover {
        background-color: var(--fc-button-hover-bg-color) !important;
        transform: translateY(-1px);
    }

    .fc-button-active {
        background-color: var(--fc-button-active-bg-color) !important;
        border-color: var(--fc-button-active-border-color) !important;
        color: #fff !important;
    }

    .fc-button:focus {
        box-shadow: none !important;
    }

    /* --- LA TABLA / GRILLA --- */
    .fc-theme-standard td,
    .fc-theme-standard th {
        border-color: var(--fc-border-color) !important;
    }

    /* Encabezados de día (Lunes, Martes...) */
    .fc-col-header-cell-cushion {
        color: #64748b;
        /* Gris suave */
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.05em;
        padding-bottom: 10px !important;
    }

    /* --- CELDAS Y NÚMEROS --- */
    .fc-daygrid-day-number {
        color: #334155;
        font-size: 0.9rem;
        font-weight: 500;
        padding: 8px 12px !important;
    }

    /* Día Actual */
    .fc-day-today {
        background-color: transparent !important;
    }

    /* Círculo azul en el número del día actual */
    .fc-day-today .fc-daygrid-day-number {
        background-color: #3b82f6;
        color: white;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 4px;
    }

    /* --- EVENTOS --- */
    .fc-event {
        border: none !important;
        border-radius: 4px !important;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        padding: 2px 4px;
        margin-bottom: 2px !important;
        transition: transform 0.1s;
    }

    .fc-event:hover {
        transform: scale(1.02);
        cursor: pointer;
    }

    /* Eventos tipo "Punto" (mes) */
    .fc-daygrid-event-dot {
        border-width: 4px !important;
        /* Punto un poco más grande */
    }

    /* Texto del evento */
    .fc-event-title {
        font-weight: 500;
        font-size: 0.85rem;
    }

    /* Eliminar scrollbar feo en días con muchos eventos */
    .fc-daygrid-day-bottom {
        margin-top: 2px;
    }

    /* Modal styles clean up */
    .modal-content {
        border: none;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }

    .modal-header {
        border-bottom: 1px solid #f0f0f0;
        padding: 20px;
    }

    .modal-footer {
        border-top: 1px solid #f0f0f0;
        padding: 20px;
    }

    /* 1. Contenedor flexible que permita saltos de línea si no cabe */
    .fc-header-toolbar {
        display: flex !important;
        flex-wrap: wrap !important;
        justify-content: space-between !important;
        align-items: center !important;
        gap: 10px !important;
        /* Espacio entre elementos */
        margin-bottom: 1.5rem !important;
    }

    /* 2. Ajustar el tamaño del título y evitar que rompa */
    .fc-toolbar-title {
        font-size: 1.25rem !important;
        /* Un poco más pequeño */
        white-space: nowrap !important;
        /* Que no se parta en dos líneas */
        text-align: center;
    }

    /* 3. Agrupar los botones para que no se desperdiguen */
    .fc-toolbar-chunk {
        display: flex;
        align-items: center;
        gap: 5px;
        /* Espacio entre botones del mismo grupo */
    }

    /* 4. ARREGLO CRÍTICO PARA BOTONES BOOTSTRAP/FULLCALENDAR */
    /* A veces los estilos de Bootstrap interfieren con el box-sizing */
    .fc-button {
        height: auto !important;
        padding: 0.4rem 1rem !important;
        display: inline-flex !important;
        align-items: center !important;
        justify-content: center !important;
    }

    /* Iconos dentro de los botones (flechas) alineados */
    .fc-icon {
        vertical-align: middle !important;
        font-size: 1.2em !important;
    }

    /* --- ESTILO RESPONSIVE (Para pantallas o columnas pequeñas) --- */
    @media (max-width: 768px) {
        .fc-header-toolbar {
            flex-direction: column;
            /* En móvil, uno debajo del otro */
            align-items: stretch !important;
        }

        .fc-toolbar-chunk {
            justify-content: center;
            /* Centrar botones */
            margin-bottom: 5px;
        }
    }

    a {
        text-decoration: none !important;
    }
</style>
<style>
    /* Efecto de elevación suave */
    .card-hover-effect {
        transition: transform 0.2s ease, box-shadow 0.2s ease;
    }

    .card-hover-effect:hover {
        transform: translateY(-5px);
        box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15) !important;
    }

    /* Efecto para las cards sólidas */
    .hover-scale {
        transition: transform 0.2s;
    }

    .hover-scale:hover {
        transform: scale(1.02);
    }
</style>

@endsection

@section('content')
<div class="container-fluid p-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="text-primary fw-bold"><i class="fas fa-user-md me-2"></i>Dashboard Doctor</h2>
        </div>
        <button type="button" class="btn btn-success shadow-sm" data-bs-toggle="modal" data-bs-target="#modalPagos">
            <i class="fas fa-money-bill-wave me-2"></i> Ver Pagos del Mes
        </button>
    </div>

    <div class="col-md-6 mb-3">
        <a href="#" class="text-decoration-none">
            <div class="card border-0 shadow-sm h-100 ">
                <div class="card-body d-flex align-items-center p-4">

                    <div class="rounded-circle p-3 d-flex align-items-center justify-content-center me-3"
                        style="width: 60px; height: 60px; background-color: rgba(59, 130, 246, 0.1);">
                        <i class="fas fa-user-clock fa-xl text-primary"></i>
                    </div>


                    <div>
                        <h6 class="text-muted text-uppercase small fw-bold mb-1">PAGO ACUMULADO DEL MES</h6>
                        <h5 class="fw-bold text-dark mb-0">Q. 200.00</h5>
                        <small class="text-primary mt-1 d-block">
                            <i class="fas fa-arrow-right small me-1"></i> (Q. 100.00) PENDIENTE DE ASIGNAR DIARIO
                        </small>
                    </div>
                </div>
            </div>
        </a>
    </div>

    {{-- FILA 1: LISTAS RÁPIDAS (Hoy y Mañana) --}}
    <div class="row mb-4">
        <div class="col-md-6 mb-3">
            <div class="card h-100 border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h5 class="card-title text-primary fw-bold"><i class="fas fa-calendar-day me-2"></i>Agenda de Hoy</h5>
                </div>
                <div class="card-body p-0" style="max-height: 250px; overflow-y: auto;">
                    <ul class="list-group list-group-flush">
                        @forelse ($agendaHoy as $cita)
                        <li class="list-group-item d-flex justify-content-between align-items-center px-4">
                            <div><span class="badge bg-primary rounded-pill me-2">{{ $cita->hora }}</span>
                                <span class="fw-bold">{{ $cita->pacienterelation->nombre ?? $cita->paciente }}</span>
                            </div>
                            <span class="small text-muted">{{ $cita->tratamiento }}</span>
                        </li>
                        @empty
                        <li class="list-group-item text-center text-muted py-3">Sin citas hoy.</li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-md-6 mb-3">
            <div class="card h-100 border-0 shadow-sm">
                <div class="card-header bg-white border-bottom-0">
                    <h5 class="card-title text-info fw-bold"><i class="fas fa-calendar-plus me-2"></i>Agenda de Mañana</h5>
                </div>
                <div class="card-body p-0" style="max-height: 250px; overflow-y: auto;">
                    <ul class="list-group list-group-flush">
                        @forelse ($agendaManana as $cita)
                        <li class="list-group-item d-flex justify-content-between align-items-center px-4">
                            <div><span class="badge bg-info text-dark rounded-pill me-2">{{ $cita->hora }}</span>
                                <span class="fw-bold">{{ $cita->pacienterelation->nombre ?? $cita->paciente }}</span>
                            </div>
                            <span class="small text-muted">{{ $cita->tratamiento }}</span>
                        </li>
                        @empty
                        <li class="list-group-item text-center text-muted py-3">Sin citas mañana.</li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>
    </div>

    {{-- FILA 2: CALENDARIO MENSUAL COMPLETO --}}
    <div class="row">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white">
                    <h5 class="mb-0 fw-bold"><i class="fas fa-calendar-alt me-2"></i>Calendario General</h5>
                </div>
                <div class="card-body p-3">
                    <div id="calendar"></div>
                </div>
            </div>
        </div>
    </div>

    {{-- CARD 1: PACIENTES DE HOY --}}
    <div class="col-md-6 mb-3">
        <a href="{{ route('doc.pacientesHoy') }}" class="text-decoration-none">
            <div class="card border-0 shadow-sm bg-primary text-white h-100 hover-scale">
                <div class="card-body p-4 d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-1">Pacientes de Hoy</h4>
                        <p class="mb-0 text-white-50 small">Gestionar asistencias del día</p>
                    </div>
                    <i class="fas fa-user-clock fa-3x text-white-50"></i>
                </div>
            </div>
        </a>
    </div>

    {{-- CARD 2: REPORTES --}}
    <div class="col-md-6 mb-3">
        <a href="{{ route('doc.reportes') }}" class="text-decoration-none">
            <div class="card border-0 shadow-sm bg-success text-white h-100 hover-scale">
                <div class="card-body p-4 d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold mb-1">Reportes</h4>
                        <p class="mb-0 text-white-50 small">Ver ingresos y estadísticas</p>
                    </div>
                    <i class="fas fa-chart-pie fa-3x text-white-50"></i>
                </div>
            </div>
        </a>
    </div>



</div>

{{-- MODAL PAGOS (Tu código original) --}}
<div class="modal fade" id="modalPagos" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Pagos del Mes</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-0">
                <table class="table table-striped mb-0">
                    <thead>
                        <tr>
                            <th>Paciente</th>
                            <th>Fecha</th>
                            <th>Tratamiento</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pagos as $his)
                        <tr>
                            <td>{{ $his->nombre }}</td>
                            <td>{{ $his->created_at }}</td>
                            <td>{{ $his->tratamiento }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

{{-- MODAL DETALLE CITA (Solo Lectura) --}}
<div class="modal fade" id="modalDetalleCita" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Detalle de la Cita</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="fw-bold text-muted small">PACIENTE</label>
                    <h5 id="verPaciente" class="text-dark"></h5>
                </div>
                <div class="row mb-3">
                    <div class="col-6">
                        <label class="fw-bold text-muted small">FECHA</label>
                        <p id="verFecha" class="mb-0"></p>
                    </div>
                    <div class="col-6">
                        <label class="fw-bold text-muted small">HORA</label>
                        <p id="verHora" class="mb-0"></p>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="fw-bold text-muted small">TRATAMIENTO</label>
                    <p id="verTratamiento" class="mb-0 bg-light p-2 rounded"></p>
                </div>
                <div class="mb-3">
                    <label class="fw-bold text-muted small">ESTADO</label>
                    <span id="verEstado" class="badge"></span>
                </div>
                <div>
                    <label class="fw-bold text-muted small">OBSERVACIONES</label>
                    <p id="verObservaciones" class="mb-0 text-muted fst-italic">Ninguna</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/locales/es.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            locale: 'es',
            initialView: 'dayGridMonth', // Vista mensual para "ver todo"
            themeSystem: 'standard', // Usamos nuestros estilos CSS personalizados
            headerToolbar: {
                // Ponemos todo junto de forma más compacta
                left: 'prev,next',
                center: 'title',
                right: 'today dayGridMonth,listWeek'
            },
            // --- CONFIGURACIÓN SOLO LECTURA ---
            editable: false, // No arrastrar
            selectable: false, // No crear clicando vacíos
            droppable: false, // No soltar externo
            // ---------------------------------

            // Altura automática para que no tenga scrollbars dobles
            height: 'auto',
            // Textos personalizados
            buttonText: {
                today: 'Hoy',
                month: 'Mes',
                list: 'Agenda'
            },

            // Cargar eventos reutilizando tu API existente
            events: {
                url: "{{ route('agenda.getEvents') }}",
                extraParams: {
                    // Inyectamos el ID del doctor logueado desde la sesión de Laravel
                    doctor_id: "{{ session()->get('doctor_id') }}"
                }
            },

            // Al hacer clic, mostramos el modal de SOLO LECTURA
            eventClick: function(info) {
                var props = info.event.extendedProps;
                var start = info.event.start;

                // Formatear hora
                var hora = start.getHours().toString().padStart(2, '0') + ':' +
                    start.getMinutes().toString().padStart(2, '0');

                // Formatear fecha (DD/MM/YYYY)
                var fecha = start.getDate().toString().padStart(2, '0') + '/' +
                    (start.getMonth() + 1).toString().padStart(2, '0') + '/' +
                    start.getFullYear();

                // Sacar nombre del paciente del título (quitando el icono y tratamiento)
                // O usar props.paciente_text si tu controller lo devuelve
                // Por simplicidad usaremos el título completo o lo que tengas en props

                // Si tu API devuelve el nombre limpio en props, úsalo:
                // $('#verPaciente').text(props.paciente_text || "Paciente");

                // Si no, limpiamos un poco el título visualmente:
                $('#verPaciente').text(info.event.title);

                $('#verFecha').text(fecha);
                $('#verHora').text(hora);
                $('#verTratamiento').text(props.tratamiento || 'Consulta');
                $('#verObservaciones').text(props.observaciones || 'Sin observaciones');

                // Color del badge estado
                var estado = props.estado || 'PENDIENTE';
                var badgeClass = 'bg-secondary';
                if (estado === 'REALIZADO') badgeClass = 'bg-success';
                if (estado === 'CANCELADO') badgeClass = 'bg-danger';
                if (estado === 'PENDIENTE') badgeClass = 'bg-warning text-dark';

                $('#verEstado').text(estado).attr('class', 'badge ' + badgeClass);

                // Abrir modal
                var myModal = new bootstrap.Modal(document.getElementById('modalDetalleCita'));
                myModal.show();
            }
        });

        calendar.render();
    });
</script>
@endsection