@extends('layouts.auth')
@section('content')
    <div class="header">



        <div class="container">
            <form method="POST" action="{{ route('login') }}" class="form">
                @csrf
                <h1>LOGIN</h1>
                <img src="{{ asset('logos/icono.jpg') }}" width="250" height="180" style="border-radius: 25px;">

                <div class="input" style="margin-top: 5%;">
                    <input type="email" class="form-control @error('email') is-invalid @enderror form-input"
                        name="email" value="{{ old('email') }}" required id="email" placeholder="Email" required>
                    <label for="email" id="email_label" class="label">CORREO</label>
                </div>
                <div class="input">
                    <input type="password" placeholder="Password" id="password"
                        class="form-input form-control @error('password') is-invalid @enderror" name="password" required>
                    <label for="password" class="label" class="form-input">CONTRASEÑA</label>

                </div>
                <p><a href="{{ route('password.request') }}">OLVIDASTE TU CONTRASEÑA?</a></p>
                <p>
                    @error('email')
                        <span class="invalid-feedback" style="color: red" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                    @error('password')
                        <span class="invalid-feedback" style="color: red" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
                </p>
                <button type="submit" id="submit_button">Login</button>

                <br>
                <br>

                <a class="btn btn-primary btn-sm" href="{{ route('login_doctor') }}" role="button">DOCTOR</a>

            </form>



        </div>

        <!--Waves Container-->
        <div>
            <svg class="waves" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                viewBox="0 24 150 28" preserveAspectRatio="none" shape-rendering="auto">
                <defs>
                    <path id="gentle-wave" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z" />
                </defs>
                <g class="parallax">
                    <use xlink:href="#gentle-wave" x="48" y="0" fill="rgba(255,255,255,0.7" />
                    <use xlink:href="#gentle-wave" x="48" y="3" fill="rgba(255,255,255,0.5)" />
                    <use xlink:href="#gentle-wave" x="48" y="5" fill="rgba(255,255,255,0.3)" />
                    <use xlink:href="#gentle-wave" x="48" y="7" fill="#fff" />
                </g>
            </svg>
        </div>
        <!--Waves end-->

    </div>
@endsection
