@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('assets/theme/vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">

@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col">
            <div class="card p-4">
                @if(session('clienteid') && session('factura'))
                <div class="alert alert-info alert-dismissible fade show text-center" role="alert">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <a href="{{route('ventaK.facturaPrint', ['idFactura' => session('factura'), 'idCliente' => session('clienteid')] )}}" target="_blank"> <i class="fa fa-print" aria-hidden="true"></i> Imprimir Factura</a>
                </div>
                @endif




                <form action="{{route('ventaK.store')}}" method="post" autocomplete="off">
                    @csrf

                    <h1 class="display-4 text-center">Datos De Venta</h1>


                    <!-- paneles -->
                    <div class="row p-4">
                        <!-- panel izquierdo -->
                        <div class="col-md-9">

                            <!-- articulos -->
                            <div class="form-group row">
                                <div class="col-md-10">
                                    <select class="form-control" name="articulo" id="medicamento" autofocus>
                                        <option value="">Seleccione Articulo &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</option>
                                        @foreach($articulos as $art)
                                        <option value="{{ $art->id}}__{{$art->stock}}__{{$art->p_venta}}">{{$art->bodega}} {{$art->color}} {{$art->talla}} / {{$art->codigo}} &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp; &nbsp; &nbsp; &nbsp;</option>
                                        @endforeach
                                    </select>
                                    <br>
                                </div>
                            </div>
                            <!-- end articulos -->
                            <br>
                            <!-- clientes -->
                            <div class="form-group row mt-2">
                                <div class="col-md-10">

                                    <div class="form-group">
                                        <label for="">CLIENTE</label>
                                        <input type="text" class="form-control" name="cliente" id="" placeholder="INGRESE NOMBRE DE CLIENTE" required>

                                    </div>

                                </div>

                            </div>
                            <!-- end clientes -->

                            <!-- datos descriptivos -->
                            <div class="col-md-6">
                                <h3 class="h6">Datos Descriptivos</h3>
                                <div class="form-group row mx-3">
                                    <div class="row">
                                        <div class="col">
                                            Tipo de Venta
                                            <input type="text" class="form-control" placeholder="Tipo de Venta" disabled name="" id="tventa">

                                        </div>
                                        <div class="col">
                                            Precio
                                            <input type="text" class="form-control" placeholder="Precio Venta" disabled name="" id="pventa">

                                        </div>
                                        <div class="col">
                                            Existencia
                                            <input type="text" class="form-control" placeholder="Existencia" name="" disabled id="existencia">
                                        </div>

                                    </div>

                                    <div class="row">
                                        <div class="col">
                                            Cantidad
                                            <input type="number" class="form-control" name="" value="1" id="cantidad">
                                        </div>
                                        <div class="col">
                                            Descuento
                                            <input type="number" class="form-control" placeholder="Descuento" id="descuento">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end datos descriptivos -->
                        </div>
                        <!-- fin panel izquierdo -->

                        <!-- panel derecho -->
                        <div class="col-md-3">
                            <a style="font-size: 300%; color: blue;" id="add"> <i class="fa fa-cart-plus" aria-hidden="true"></i> </a>

                            <div class="row">
                                <div class="col text-center">
                                    Image De Descripcion <br>
                                    <img src="" id="img" class="img-fluid mt-1" style="width: 35%;">
                                </div>
                            </div>
                        </div>
                        <!-- fin panel derecho -->
                    </div>
                    <!-- paneles -->

                    <!-- decripcion de articulos -->

                    <!-- fin decripcion de articulos -->
                    <hr>
                    <!-- descripcion -->
                    <div class="container-fluid">
                        <div class="row justify-content-center">
                            <div class="col">
                                <!-- Widget: user widget style 1 -->

                                <table class="table table-hover table-inverse" id="tabla_venta">
                                    <thead class="" style="    background-color: #1eb3a2;color: white;">
                                        <tr>
                                            <th>Accion</th>
                                            <th>Articulo</th>
                                            <th>Precio Venta</th>
                                            <th>Descuento</th>
                                            <th>Cantidad</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <tr>

                                        </tr>

                                    </tbody>
                                </table>

                                <!-- /.widget-user -->
                            </div>
                        </div>
                    </div>
                    <!-- fin descripcio -->
                    <!-- totales -->
                    <div class="row justify-content-end">
                        <div class="col-4">
                            <p class="lead">
                                <font style="vertical-align: inherit;">
                                    <font style="vertical-align: inherit;">Monto a Pagar </font>
                                </font>
                            </p>

                            <div class="table-responsive">
                                <table class="table">
                                    <tbody>
                                        <tr>
                                            <th>
                                                <font style="vertical-align: inherit;">
                                                    <font style="vertical-align: inherit;">Total:Q</font>
                                                </font>
                                            </th>
                                            <td>
                                                <label id="total"> </label>

                                            </td>
                                        </tr>

                                        <tr>
                                            <th>
                                                <font style="vertical-align: inherit;">
                                                    <font style="vertical-align: inherit;">Efectivo:Q</font>
                                                </font>

                                            <td>
                                                <input type="text" class="form-control" name="" id="efectivo" placeholder="Efectivo">

                                            </td>

                                            </th>
                                        </tr>

                                        <tr>
                                            <th>
                                                <font style="vertical-align: inherit;">
                                                    <font style="vertical-align: inherit;">Cambio:Q</font>
                                                </font>
                                            </th>

                                            <td>
                                                <input type="text" class="form-control" name="" disabled id="cambio" placeholder="Cambio">

                                            </td>
                                        </tr>

                                        <tr>
                                            <th>

                                            </th>

                                            <td>
                                                <button type="button" onclick="cambiofun()" class="btn btn-success"> <i class="fa fa-money" aria-hidden="true"></i> Calcular Cambio</button>

                                                <!-- <p>
                                                <button class="btn btn-warning btn-sm mt-4" type="button" data-toggle="collapse" data-target="#contentId" aria-expanded="false" aria-controls="contentId">
                                                    <i class="fa fa-plus-circle" aria-hidden="true"></i> EXTRAS
                                                </button>
                                            </p> -->
                                            </td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- fin totales -->
                    <div class="form-group">
                        <label for="">Descripcion de Venta</label>
                        <textarea class="form-control" name="des_min" rows="2"></textarea>
                    </div>
                    <!-- collaspe extras -->
                    <div class="collapse" id="contentId">

                        <p class="text-center h3">Mayoritas</p>

                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="checkbox" class="form-check-input" name="mayorista_check" id="" value="true">
                                Mayorista
                            </label>
                        </div>

                        <!-- <div class="form-check">
                        <label class="form-check-label">
                            <input type="checkbox" class="form-check-input" name="credito" id="" value="true">
                            Venta al Credito ?
                        </label>
                        </div> -->

                        <div class="form-group">
                            <label for="">Descueto</label>
                            <input type="text" class="form-control" name="descuento_mayo" id="descuento_mayorista" placeholder="Descueto Para Mayoristas">
                        </div>


                        <div class="form-group">
                            <label for="">Descripcion de Venta</label>
                            <textarea class="form-control" name="descripcion" rows="3" cols="10"></textarea>
                        </div>

                        <div class="form-group">
                            <button type="button" class="btn btn-dark" onclick="nuevototal()" id="newTotal"> Calcular Total</button>
                        </div>


                    </div>
                    <!-- end collapce-->
                    <hr>
                    <button type="submit" class="btn btn-primary">Registrar Venta</button>
                </form>

            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')

<script src="{{asset('assets/theme/vendor/select2/select2.min.js')}}"></script>

<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>
<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#select',
            placeholder: 'Select Permissions',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);
</script>

<script>
    $(document).ready(function() {
        $('#idcliente').select2({
            width: '100% !important'
        });
        $('#medicamento').select2({
            width: '100% !important'
        });
    });
</script>

<script>
    var cliente = $('#idcliente');
    var total_venta = $('#total');
    var tabla = $('#tabla_venta');
    var btn_add = $('#add');
    var medicamento = $('#medicamento');
    var pventa = $('#pventa');
    var existenci = $('#existencia');
    var efectivo = $('#efectivo');
    var cambio = $('#cambio');
    var descuento = $('#descuento');
    var descArt = $('#descripArt');
    var descArtInter = $('#descripArtInter');
    var img = $('#img');
    var tventa = $('#tventa');

    var total = 0;
    var cont = 0;
    var subtotal = Array;


    medicamento.change(mostrarvalores);

    function mostrarvalores() {
        datosmerdicamento = document.getElementById('medicamento').value.split('__');
        existenci.val(datosmerdicamento[1]);
        pventa.val(datosmerdicamento[2]);
        descArt.val(datosmerdicamento[3]);
        descArtInter.val('DESCRIPCION INTERNA \n ' + datosmerdicamento[4]);
        $("#img").attr("src", datosmerdicamento[5]);
        tventa.val(datosmerdicamento[6]);

        console.log(datosmerdicamento);

        // agregar();
    }

    function limpiar() {
        var medicamento = $('#medicamento').val('');

        let pventa = $('#pventa').val('');
        let existenci = $('#existencia').val('');
        let cantidad = $('#cantidad').val('1');
        var descuento = $('#descuento').val('');
        var tventa = $('#tventa').val('');
        img = '';
        medicamento.focus();
    }

    btn_add.click(function() {
        agregar();
    })

    function agregar() {


        datosmerdicamento = document.getElementById('medicamento').value.split('_');

        var idmedicamento = datosmerdicamento[0];
        let pventa = parseFloat($('#pventa').val());
        let existenci = $('#existencia').val();

        let cantidad = parseInt($('#cantidad').val());
        let medicamento = $('#medicamento option:selected').text();

        var descuento = $('#descuento').val();



        var newdescuento = 0;


        if (descuento > 0) {

            newdescuento = (descuento) * cantidad;
            console.log(newdescuento);

        }



        // console.log(pventa);
        // console.log(cantidad);

        if (idmedicamento != "" && pventa != "" && existenci != "" && cantidad != "") {
            if (cantidad <= existenci) {

                subtotal[cont] = (cantidad * pventa) - newdescuento;
                total = total + subtotal[cont];

                var fila = '<tr class="selected" id="fila' + cont + '">' +
                    '<td><a href="#" class="btn btn-danger btn-sm" onclick="eliminar_fila(' + cont + ')">X</a></td>' +
                    '<td><input type="hidden" name="idArticulos[]" value="' + idmedicamento + '">' + medicamento + '</td>' +
                    '<td><input type="number" class="form-control"  name="pventa[]" value="' + pventa + '" readonly></td> ' +
                    '<td><input type="number" class="form-control"  name="descuento[]" value="' + newdescuento + '" readonly ></td> ' +
                    '<td><input type="number" class="form-control"  name="cantidad[]" value="' + cantidad + '" readonly ></td> ' +
                    '<td> <input type="hidden" name="subtotal[]" value="' + subtotal[cont] + '">' + subtotal[cont] + '</td>' +
                    '</tr>';
                cont++;
                limpiar();

                total_venta.html('<input type="number" id="totvent" name="totalventa" class="form-control" value="' + total + '" readonly >');
                tabla.append(fila);
            } else {
                alert('LA CANTIDAD A VENDER SUERA LA EXISTENCIA');
            }

        } else {
            alert('TODOS LOS CAMPOS DEBEN DE ESTAR LLENOS');
        }
    }

    function eliminar_fila(index) {
        total = total - subtotal[index];

        total_venta.html('<input type="number" name="totalventa" class="form-control" value="' + total + '" readonly >');
        $('#fila' + index).remove();
    }

    function cambiofun() {

        var totVent = $('#totvent').val();

        var cambio = parseFloat(efectivo.val()) - parseFloat(totVent);

        console.log(cambio);

        $('#cambio').val(cambio);


    }


    function nuevototal() {

        let total = parseFloat($('#totvent').val());

        let descuento = parseFloat($('#descuento_mayorista').val());

        if (descuento > 0) {

            let newdescuento = (total * descuento) / 100;

            let newTotalDec = total - newdescuento;

            $('#totvent').val(newTotalDec);



        } else {
            return;
        }
    }
</script>


@endsection