@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection


@section('content')



<div class="container-fluid mb-5">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title display-2 text-center mb-4 text-info">Historial de Ventas</h4> <br>


                    <!-- ventas al contado -->

                    <table class="table table-hover" id="contado" data-page-length="15">
                        <thead>
                            <tr>
                                <th>No. Factura</th>
                                <th>Cliente</th>

                                <th>Fecha / Hora de Venta</th>
                                <th>Accion</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($contado as $con)
                            <tr>
                                <td>{{$con->factura_id}}</td>
                                <td>{{$con->cliente}}</td>
                                <td>{{$con->fechaVenta}}</td>
                                <td>

                                    <a target="_blank" class="btn btn-primary btn-sm" href="{{route('ventaK.facturaPrint', ['idFactura' => $con->factura_id] )}}"><i class="fa fa-print" aria-hidden="true"></i> Imprimir Factura</a>

                                    <a class="btn btn-danger btn-sm mt-1" href="{{route('ventaK.delete', ['id' => $con->factura_id, 'idArt' => $con->articulo_id] )}}"> <i class="fa fa-trash" aria-hidden="true"></i>Eliminar Venta</a>

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- end ventas al contado -->
                    <hr>
                    <br>
                    <br>
                    <br>

                    <!-- ventas al crediro -->
                    <!-- <h4 class="display-4 mb-4 text-success">Ventas al Credito</h4>
                <table class="table table-hover" id="credito" data-page-length="15">
                    <thead>
                        <tr>
                            <th>No. Factura</th>
                            <th>Cliente</th>
                            
                            <th>Credito</th>
                            <th>Fecha / Hora de Venta</th>
                            <th>Accion</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($credito as $cre)
                        <tr>
                            <td>{{$cre->factura_id}}</td>
                            <td>{{$cre->nombre}}</td>
                           
                            <td>
                                <div class="form-check">
                                    <label class="form-check-label">
                                        <input type="checkbox" class="form-check-input" value="checkedValue" checked>
                                        Credito
                                    </label>
                                </div>
                            </td>
                            <td>{{$cre->fechaVenta}}</td>
                            <td>
                                <a target="_blank" class="btn btn-primary btn-sm" href="{{route('venta.facturaPrint', ['idFactura' => $con->factura_id, 'idCliente' => $con->cliente_id] )}}"><i class="fa fa-print" aria-hidden="true"></i> Imprimir Factura</a>

                                <a class="btn btn-danger btn-sm mt-1" href="{{route('venta.delete', ['id' => $cre->id, 'idArt' => $cre->articulo_id] )}}"> <i class="fa fa-trash" aria-hidden="true"></i>Eliminar Venta</a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table> -->

                </div>
            </div>
        </div>
    </div>
</div>



@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#contado').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'Siguiente',
                    'previous': 'Atras'
                },
                'loadingRecords': 'Cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });

        $('#credito').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'Siguiente',
                    'previous': 'Atras'
                },
                'loadingRecords': 'Cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection