@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('assets/theme/vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
<style>
    .card-pos {
        border: none;
        box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    }

    .total-header {
        background-color: #28a745;
        color: white;
        padding: 20px;
        border-radius: 5px;
        text-align: center;
    }

    .img-preview {
        max-height: 150px;
        object-fit: contain;
        border-radius: 10px;
        border: 1px solid #ddd;
    }

    .table-vcenter td,
    .table-vcenter th {
        vertical-align: middle;
    }
</style>
@endsection

@section('content')
<div class="container-fluid mb-5">

    {{-- Alertas --}}
    @if(session('clienteid') || session('factura'))
    <div class="alert alert-info alert-dismissible fade show text-center shadow-sm" role="alert">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <a href="{{route('venta.facturaPrint', ['idFactura' => session('factura'), 'idCliente' => session('clienteid')] )}}" target="_blank" class="font-weight-bold">
            <i class="fa fa-print"></i> Imprimir Factura Generada
        </a>
    </div>
    @endif

    <form action="{{route('venta.store')}}" method="post" autocomplete="off">
        @csrf

        <div class="row">
            {{-- COLUMNA IZQUIERDA: PRODUCTOS Y TABLA --}}
            <div class="col-lg-8">
                <div class="card card-pos mb-4">
                    <div class="card-header bg-white font-weight-bold text-primary">
                        <i class="fa fa-shopping-cart"></i> Selección de Productos
                    </div>
                    <div class="card-body">

                        {{-- Buscador de Artículos --}}
                        <div class="form-group">
                            <label class="font-weight-bold">Buscar Artículo / Código de Barras</label>
                            <select class="form-control" name="articulo" id="medicamento" autofocus>
                                <option value="">Escriba para buscar...</option>
                                @foreach($articulos as $art)
                                @foreach($art->lotes as $lote)
                                <option value="{{ $art->id }}__{{ $lote->id }}__{{ $lote->cantidad }}__{{ $art->p_venta }}__{{ $art->descripcion }}__{{ $art->descripcion_interna }}__{{ $art->img }}__{{ $art->categoria->nombre }}__{{ $lote->fecha_caducidad }}">
                                    {{ $art->nombre }} - Q{{ $art->p_venta }} (Stock: {{ $lote->cantidad }}) - Lote: {{ $lote->fecha_caducidad }}
                                </option>
                                @endforeach
                                @endforeach
                            </select>
                        </div>

                        {{-- Detalles del Producto Seleccionado --}}
                        <div class="row">
                            <div class="col-md-3">
                                <label><small>Precio Venta</small></label>
                                <div class="input-group mb-2">
                                    <div class="input-group-prepend"><span class="input-group-text">Q</span></div>
                                    <input type="text" class="form-control" placeholder="0.00" disabled id="pventa">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label><small>Existencia</small></label>
                                <input type="text" class="form-control mb-2" placeholder="0" disabled id="existencia">
                            </div>
                            <div class="col-md-3">
                                <label><small>Cantidad</small></label>
                                <input type="number" class="form-control mb-2" value="1" id="cantidad" min="1">
                            </div>
                            <div class="col-md-3">
                                <label><small>Descuento (Q)</small></label>
                                <input type="number" class="form-control mb-2" placeholder="0.00" id="descuento" value="0">
                            </div>
                        </div>

                        {{-- Datos Ocultos pero necesarios --}}
                        <input type="hidden" disabled id="tventa">

                        <div class="row mt-2">
                            <div class="col-md-8">
                                <label><small>Descripción Interna</small></label>
                                <textarea class="form-control form-control-sm bg-light" id="descripArtInter" rows="2" disabled></textarea>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="button" class="btn btn-primary btn-block shadow" id="add">
                                    <i class="fa fa-plus-circle"></i> AGREGAR A LA LISTA
                                </button>
                            </div>
                        </div>

                        {{-- Imagen Previa --}}
                        <div class="row mt-3 d-none" id="divImagen">
                            <div class="col-12 text-center">
                                <img src="" id="img" class="img-preview">
                                <textarea class="form-control mt-2" id="descripArt" rows="2" disabled style="display:none"></textarea>
                            </div>
                        </div>

                    </div>
                </div>

                {{-- Tabla de Detalles --}}
                <div class="card card-pos">
                    <div class="card-header bg-white font-weight-bold">
                        <i class="fa fa-list-alt"></i> Detalle de la Venta
                    </div>
                    <div class="card-body p-0 table-responsive">
                        <table class="table table-striped table-vcenter table-hover mb-0" id="tabla_venta">
                            <thead class="bg-dark text-white">
                                <tr>
                                    <th style="width: 50px;">X</th>
                                    <th>Articulo</th>
                                    <th>Precio</th>
                                    <th>Desc.</th>
                                    <th>Cant.</th>
                                    <th>Lote/Vence</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            {{-- COLUMNA DERECHA: CLIENTE Y PAGO --}}
            <div class="col-lg-4">

                {{-- Selección de Cliente --}}
                <div class="card card-pos mb-4">
                    <div class="card-header bg-white font-weight-bold text-info">
                        <i class="fa fa-user"></i> Datos del Cliente
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Nombre Facturación (NIT/CF)</label>
                            <input type="text" class="form-control" name="cliente" placeholder="Nombre en factura">
                        </div>
                        <div class="form-group">
                            <label>Seleccionar Paciente</label>
                            <select id="paciente_id" class="form-control" name="paciente_id">
                                <option value="">Público General / Otro</option>
                                @foreach ($pacientes as $paciente)
                                <option value="{{$paciente->id}}">{{$paciente->nombre}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                {{-- Sección de Totales y Pago --}}
                <div class="card card-pos">
                    <div class="card-body">

                        <div class="total-header mb-4">
                            <small class="d-block">TOTAL A PAGAR</small>
                            <h1 class="display-4 font-weight-bold" id="total_display">Q 0.00</h1>
                        </div>
                        <input type="hidden" name="totalventa" id="totvent" value="0">

                        {{-- NUEVO: Tipo de Pago --}}
                        <div class="form-group">
                            <label class="font-weight-bold"><i class="fa fa-credit-card"></i> Tipo de Pago</label>
                            <select class="form-control form-control-lg" name="tipo_pago" required>
                                <option value="Efectivo" selected>Efectivo</option>
                                <!-- <option value="Tarjeta">Tarjeta de Crédito/Débito</option> -->
                                <option value="Transferencia">Transferencia Bancaria</option>
                                <option value="Deposito">Depósito</option>
                                <!-- <option value="Cheque">Cheque</option> -->
                                <!-- <option value="Seguro">Seguro Médico</option> -->
                                <!-- <option value="Otro">Otro</option> -->
                            </select>
                        </div>

                        <div class="form-group row">
                            <div class="col-6">
                                <label>Efectivo Recibido</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text">Q</span></div>
                                    <input type="number" step="0.01" class="form-control" name="efectivo" id="efectivo" onkeyup="cambiofun()">
                                </div>
                            </div>
                            <div class="col-6">
                                <label>Cambio</label>
                                <div class="input-group">
                                    <div class="input-group-prepend"><span class="input-group-text">Q</span></div>
                                    <input type="text" class="form-control" name="cambio" id="cambio" readonly>
                                </div>
                            </div>
                        </div>

                        <button type="button" onclick="cambiofun()" class="btn btn-outline-secondary btn-sm btn-block mb-3">
                            <i class="fa fa-calculator"></i> Recalcular Cambio
                        </button>

                        <hr>

                        {{-- Opciones Extra (Colapsables) --}}
                        <p>
                            <a class="btn btn-link btn-sm pl-0" data-toggle="collapse" href="#collapseExtras" role="button" aria-expanded="false">
                                <i class="fa fa-cog"></i> Opciones Avanzadas (Mayorista / Notas)
                            </a>
                        </p>
                        <div class="collapse" id="collapseExtras">
                            <div class="card card-body bg-light mb-3">
                                <div class="form-check mb-2">
                                    <input type="checkbox" class="form-check-input" name="mayorista_check" id="mayorista_check" value="true">
                                    <label class="form-check-label" for="mayorista_check">Aplicar Precio Mayorista</label>
                                </div>
                                <div class="form-group">
                                    <label><small>% Descuento Global</small></label>
                                    <input type="number" class="form-control form-control-sm" name="descuento_mayo" id="descuento_mayorista" placeholder="0">
                                    <button type="button" class="btn btn-dark btn-sm mt-2 btn-block" onclick="nuevototal()">Aplicar Descuento</button>
                                </div>
                                <div class="form-group d-none">
                                    <label><small>Nota de Venta</small></label>
                                    <textarea class="form-control form-control-sm" name="descripcion" rows="2"></textarea>
                                </div>
                            </div>
                        </div>

                        {{-- Botón Final --}}
                        <button type="submit" class="btn btn-success btn-lg btn-block shadow">
                            <i class="fa fa-check-circle"></i> CONFIRMAR VENTA
                        </button>

                    </div>
                </div>

            </div>
        </div>
    </form>
</div>
@endsection

@section('scripts')
<script src="{{asset('assets/theme/vendor/select2/select2.min.js')}}"></script>
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}"></script>
<script>
    // Inicialización de selects
    document.addEventListener("DOMContentLoaded", function() {
        setTimeout(function() {
            new SlimSelect({
                select: '#medicamento',
                placeholder: 'Buscar Producto...',
                deselectLabel: '<span>&times;</span>',
            });
            new SlimSelect({
                select: '#paciente_id',
                placeholder: 'Seleccionar Paciente',
            });
        }, 300);
    });

    // Variables Globales
    var tabla = $('#tabla_venta tbody');
    var btn_add = $('#add');
    var medicamento = $('#medicamento');
    var pventa = $('#pventa');
    var existenci = $('#existencia');
    var efectivo = $('#efectivo');
    var cambio = $('#cambio');
    var descuento = $('#descuento');
    var descArtInter = $('#descripArtInter');
    var img = $('#img');
    var tventa = $('#tventa');

    // --- CORRECCIÓN IMPORTANTE ---
    // BORRAMOS LAS LÍNEAS QUE CREABAN EL INPUT CON JS.
    // Usaremos únicamente el que pusiste manualmente en el HTML con id="totvent"

    var total = 0;
    var cont = 0;
    var subtotal = [];

    // Eventos
    medicamento.change(mostrarvalores);
    btn_add.click(agregar);

    function mostrarvalores() {
        var valor = document.getElementById('medicamento').value;
        if (!valor) return;

        datosmerdicamento = valor.split('__');
        existenci.val(datosmerdicamento[2]);
        pventa.val(datosmerdicamento[3]);
        descArtInter.val(datosmerdicamento[5]);

        if (datosmerdicamento[6]) {
            $("#img").attr("src", datosmerdicamento[6]);
            $("#divImagen").removeClass('d-none');
        } else {
            $("#divImagen").addClass('d-none');
        }

        tventa.val(datosmerdicamento[7]);
        $('#cantidad').focus();
    }

    function limpiar() {
        $('#cantidad').val('1');
        $('#descuento').val('0');
    }

    function agregar() {
        var valor = document.getElementById('medicamento').value;
        if (!valor) {
            alert("Seleccione un artículo");
            return;
        }

        datosmerdicamento = valor.split('__');
        var idmedicamento = datosmerdicamento[0];
        var idLote = datosmerdicamento[1];
        let precio_venta = parseFloat($('#pventa').val());
        let stock_actual = parseFloat(datosmerdicamento[2]);
        let cantidad = parseInt($('#cantidad').val());
        let nombre_medicamento = $('#medicamento option:selected').text().split('-')[0];
        var desc_monto = parseFloat($('#descuento').val()) || 0;
        var fechaCaducidad = datosmerdicamento[8];

        if (cantidad > stock_actual) {
            alert('Stock insuficiente. Disponible: ' + stock_actual);
            return;
        }
        if (cantidad <= 0) {
            alert('La cantidad debe ser mayor a 0');
            return;
        }

        var descuento_total_item = desc_monto;
        var subtotal_fila = (cantidad * precio_venta) - descuento_total_item;

        subtotal[cont] = subtotal_fila;
        total = total + subtotal[cont];

        var fila = '<tr class="selected" id="fila' + cont + '">' +
            '<td><button type="button" class="btn btn-danger btn-sm rounded-circle" onclick="eliminar_fila(' + cont + ')"><i class="fa fa-trash"></i></button></td>' +
            '<td><input type="hidden" name="idArticulos[]" value="' + idmedicamento + '">' +
            '<input type="hidden" name="idLotes[]" value="' + idLote + '">' +
            '<span class="font-weight-bold">' + nombre_medicamento + '</span></td>' +
            '<td><input type="hidden" name="pventa[]" value="' + precio_venta + '">Q ' + precio_venta.toFixed(2) + '</td>' +
            '<td><input type="hidden" name="descuento[]" value="' + descuento_total_item + '">Q ' + descuento_total_item.toFixed(2) + '</td>' +
            '<td><input type="hidden" name="cantidad[]" value="' + cantidad + '">' + cantidad + '</td>' +
            '<td><small class="text-muted">' + fechaCaducidad + '</small></td>' +
            '<td><input type="hidden" name="subtotal[]" value="' + subtotal_fila + '"><strong>Q ' + subtotal_fila.toFixed(2) + '</strong></td>' +
            '</tr>';

        cont++;
        tabla.append(fila);

        // Llamamos a actualizar UNA sola vez
        actualizarTotales();
        limpiar();
    }

    function actualizarTotales() {
        // 1. Calculamos el valor
        let totalFinal = parseFloat(total).toFixed(2);

        // 2. Actualizamos la vista (El texto grande H1)
        $('#total_display').text("Q " + totalFinal);

        // 3. Actualizamos el input oculto (Para la base de datos)
        // Usamos JS nativo para garantizar que agarre el ID correcto
        var inputOculto = document.getElementById('totvent');

        if (inputOculto) {
            inputOculto.value = totalFinal;
            // console.log("Total actualizado a: " + totalFinal); // Descomentar para probar
        } else {
            alert("Error crítico: No se encuentra el campo oculto 'totvent'");
        }

        // 4. Recalcular cambio
        cambiofun();
    }

    function eliminar_fila(index) {
        total = total - subtotal[index];
        $('#fila' + index).remove();
        actualizarTotales();
    }

    function cambiofun() {
        // Usamos el valor del input oculto, que es el real
        var totVent = parseFloat($('#totvent').val()) || 0;
        var efect = parseFloat($('#efectivo').val()) || 0;

        if (efect > 0) {
            var camb = efect - totVent;
            if (camb < 0) {
                $('#cambio').val("Faltan Q " + Math.abs(camb).toFixed(2));
                $('#cambio').addClass('text-danger font-weight-bold');
            } else {
                $('#cambio').val(camb.toFixed(2));
                $('#cambio').removeClass('text-danger font-weight-bold');
            }
        } else {
            $('#cambio').val('');
        }
    }

    function nuevototal() {
        let currentTotal = parseFloat(total);
        let porc_desc = parseFloat($('#descuento_mayorista').val()) || 0;

        if (porc_desc > 0) {
            let monto_descuento = (currentTotal * porc_desc) / 100;
            let nuevo_total = currentTotal - monto_descuento;

            $('#total_display').html("Q " + nuevo_total.toFixed(2) + " <small style='font-size:15px'>(Desc " + porc_desc + "%)</small>");
            $('#totvent').val(nuevo_total.toFixed(2));

            cambiofun();
        } else {
            actualizarTotales();
        }
    }
</script>
@endsection