@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection


@section('content')



<div class="container-fluid mb-5">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <h4 class=" display-5 text-center mb-4 text-info">Historial de Ventas</h4> <br>
                    <form action="" class="form-inline" method="get">
                        <div class="form-group">
                            <label for="">FECHA DE VENTA</label>
                            <input type="date" class="form-control" name="fecha">
                        </div>

                        <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i></button>
                    </form>



                    <table class="table table-hover" id="contado" data-page-length="15">
                        <thead>
                            <tr>
                                <th>No. Factura</th>
                                <th>Cliente</th>

                                <th>Fecha / Hora de Venta</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($contado as $con)
                            <tr>
                                <td>{{$con->factura_id}}</td>
                                <td>{{$con->cliente}}</td>
                                <td>{{$con->fechaVenta}}</td>
                                <td>
                                    @can('venta_recibo')
                                    <a target="_blank" class="btn btn-primary btn-sm" href="{{route('venta.facturaPrint', ['idFactura' => $con->factura_id] )}}"><i class="fa fa-print" aria-hidden="true"></i> Imprimir Factura</a>
                                    @endcan

                                    @can('venta_anulacion')
                                    <a class="btn btn-danger btn-sm mt-1" href="{{route('venta.delete', ['id' => $con->factura_id, 'idArt' => $con->articulo_id] )}}"> <i class="fa fa-trash" aria-hidden="true"></i>Eliminar Venta</a>
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>


                </div>
            </div>
        </div>
    </div>
</div>



@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#contado').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'Siguiente',
                    'previous': 'Atras'
                },
                'loadingRecords': 'Cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });

        $('#credito').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'Siguiente',
                    'previous': 'Atras'
                },
                'loadingRecords': 'Cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection