@extends('layouts.admin')

@section('content')

<div class="card">
    <div class="card-header">{{ __('USUARIOS') }}</div>
    <div class="card-body">
        <a href="{{ route('users.index') }}" class="btn btn-light">Regresar</a>
    </div>
</div>

<div class="row">
    <div class="col-md-3">

        <div class="card">
            <img src="https://ui-avatars.com/api/?name={{$user->name}}" alt="">
            <div class="card-body">
                <h4 class="card-title">{{ $user->role->title ?? '--' }}</h4>
                <p class="card-text">{{$user->name}}</p>
            </div>
        </div>

    </div>

    <div class="col-md-9">

        <div class="card">

            <div class="card-body text-center">
                <h4 class="card-title mb-5">Datos Generales</h4>
                <p><b>Nombre:</b> {{$user->name}}</p>
                <p><b>Email:</b> {{$user->email}}</p>
                <p><b>Salario:</b> Q: {{number_format($user->sueldo, 2)}}</p>
                <p><b>Vacaciones</b> {{$user->vacaciones}}</p>
            </div>
        </div>

    </div>

</div>

@endsection