@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')

<div class="container-fluid">
   <div class="row">
      <div class="col-md-4">
         <div class="card">
            <div class="card-body">
               <h4 class="card-title">Check List</h4>
               <form action="{{route('users.reporteChekListo')}}" method="post">
                  @csrf
                  <select id="select" name="user_id" required>
                     @foreach ($users as $user)
                     <option value="{{$user->id}}">{{$user->name}}</option>
                     @endforeach
                  </select>
                  <div class="form-group">
                     <label for="">De (Fecha de Inicio): </label>
                     <input type="date" class="form-control" name="desde" placeholder="Fecha de Inicio" required>
                  </div>
                  <div class="form-group">
                     <label for="">Hasta (Fecha de Final): </label>
                     <input type="date" class="form-control" name="hasta" placeholder="Fecha de Fin" required>
                  </div>
                  <button type="submit" class="btn btn-primary">BUSCAR RESULTADOS</button>
               </form>
            </div>
         </div>

      </div>
      <div class="col-md-4">
         <div class="card">
            <div class="card-body">
               <h4 class="card-title">ACCIONES REALIZADAS</h4>

               <form action="{{route('users.reportAcciones')}}" method="get">

                  <select id="select2" name="user_id" required>
                     @foreach ($users as $user)
                     <option value="{{$user->name}}">{{$user->name}}</option>
                     @endforeach
                  </select>
                  <div class="form-group">
                     <label for="">De (Fecha de Inicio): </label>
                     <input type="date" class="form-control" name="inicio" placeholder="Fecha de Inicio" required>
                  </div>
                  <div class="form-group">
                     <label for="">Hasta (Fecha de Final): </label>
                     <input type="date" class="form-control" name="fin" placeholder="Fecha de Fin" required>
                  </div>
                  <button type="submit" class="btn btn-primary">BUSCAR</button>

               </form>

            </div>
         </div>
      </div>
   </div>
</div>

@endsection



@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>
<script>
   setTimeout(function() {
      new SlimSelect({
         select: '#select',
         placeholder: 'Select Permissions',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300);
   setTimeout(function() {
      new SlimSelect({
         select: '#select2',
         placeholder: 'Select Permissions',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300);
</script>
@endsection