@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')

<div class="container-fluid ">
   <div class="row">
      <div class="col">
         <div class="card mb-4">
            <div class="card-body">
               <h4 class="card-title">Actividades Check List</h4>


               <!-- Button trigger modal -->
               <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#modelId">
                  NUEVA ACTIVIDAD
               </button>

               <!-- Modal -->
               <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                  <div class="modal-dialog" role="document">
                     <div class="modal-content">
                        <div class="modal-header">
                           <h5 class="modal-title">Actividades</h5>
                           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                           </button>
                        </div>
                        <form action="{{route('users.storeActividad')}}" method="post">
                           @csrf
                           <div class="modal-body">

                              <select id="select" name="user_id" required>
                                 @foreach ($users as $user)
                                 <option value="{{$user->id}}">{{$user->name}} - {{$user->email}}</option>
                                 @endforeach
                              </select>

                              <div class="form-group">
                                 <label for="">Actividad</label>
                                 <input type="text" class="form-control" name="nombre">
                              </div>

                           </div>
                           <div class="modal-footer">
                              <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
                              <button type="submit" class="btn btn-primary">GUARDAR</button>
                           </div>
                        </form>
                     </div>
                  </div>
               </div>


               <div class="table-responsive  table-responsive mb-5">
                  <table class="table table-data table-hover" id="table_id" data-page-length="15">
                     <thead style=" cursor: pointer;">
                        <tr style="background-color: black; color:white;">
                           <th style="color: white;">Nombre <i class="fa fa-sort"></i> </th>
                           <th style="color: white;">Usuario <i class="fa fa-sort"></i> </th>
                           <th style="color: white;"></th>
                        </tr>
                     </thead>
                     <tbody>
                        @foreach($actividades as $ac)

                        <tr class="tr-shadow">
                           <td>{{$ac->nombre}}</td>
                           <td>{{$ac->name}}</td>

                           <td>

                              <form action="{{route('users.deleteactividad', ['id' => $ac->id])}}" method="post">
                                 @csrf
                                 @method('DELETE')

                                 <button type="submit" class="item btn btn-danger" onclick="return confirm('¿Esta Seguro de Eliminar?')">
                                    <i class="fa fa-trash" aria-hidden="true"></i>
                                 </button>

                              </form>

                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>

<script>
   setTimeout(function() {
      new SlimSelect({
         select: '#select',
         placeholder: 'Select Permissions',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300)
</script>


<script>
   $(document).ready(function() {
      $('#table_id').DataTable({
         "language": {
            'info': '_TOTAL_ REGISTROS',
            'search': 'BUSCAR',
            'paginate': {
               'next': 'SIGUIENTE',
               'previous': 'ATRAS'
            },
            'loadingRecords': 'CARGANDO',
            'emptyTable': 'NO EXISTEN DATOS',
            'zeroRecords': 'NO EXISTEN DATOS IGUALES'
         }
      });
   });
</script>
@endsection