@extends('layouts.admin')


@section('content')

<div class="row">

    <!-- Column -->
    <div class="col">
        <div class="card">
            <div class="float-right">
                <a class="btn btn-primary" href="{{ route('tratamiento.index') }}"> <i class="fa fa-arrow-left" aria-hidden="true"></i> Atras</a>
            </div>

            <div class="card-body">

                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Tratamiento</a>
                    </li>

                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="contact-tab" data-toggle="tab" href="#contact" role="tab" aria-controls="contact" aria-selected="false">Actualizar</a>
                    </li>

                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">


                        <div class="card">
                            <div class="card-body">
                                <p>{{$tratamiento->nombre}}</p>

                                <label class="label bg-primary">{{$tratamiento->tipo}}</label>
                                <p class="">
                                    <b>Descripcion:</b> <br>
                                    {{$tratamiento->descripcion}}
                                </p>
                                <p class="">
                                    <b>Descripcion Interna:</b> <br>
                                    {{$tratamiento->descripcion_interna}}
                                </p>

                                <div class="job-meta-data"><i class="icofont icofont-safety"></i>
                                    Q. {{number_format($tratamiento->precio, 2)}}
                                </div>

                            </div>
                        </div>
                    </div>


                    <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">

                        <div class="d-flex justify-content-center mt-5">
                            <div class="card" style="width: 80%;">
                                <div class="card-body">
                                    <h4 class="card-title">Actualizar</h4> <br>

                                    <form action="" method="post">
                                        @csrf
                                        @method('PUT')

                                        @include('admin.tratamiento.formedit')


                                        <div class="row p-4">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="Enero">enero</label>
                                                    <input type="number" step="any" class="form-control" name="enero" value="{{$tratamiento->enero}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Febrero</label>
                                                    <input type="number" step="any" class="form-control" name="febrero" value="{{$tratamiento->febrero}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Marzo</label>
                                                    <input type="number" step="any" class="form-control" name="marzo" value="{{$tratamiento->marzo}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Abril</label>
                                                    <input type="number" step="any" class="form-control" name="abril" value="{{$tratamiento->abril}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Mayo</label>
                                                    <input type="number" step="any" class="form-control" name="mayo" value="{{$tratamiento->mayo}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Junio</label>
                                                    <input type="number" step="any" class="form-control" name="junio" value="{{$tratamiento->junio}}">
                                                </div>
                                            </div>
                                            <div class="col-md-6">

                                                <div class="form-group">
                                                    <label for="">Julio</label>
                                                    <input type="number" step="any" class="form-control" name="julio" value="{{$tratamiento->julio}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Agosto</label>
                                                    <input type="number" step="any" class="form-control" name="agosto" value="{{$tratamiento->agosto}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Septiembre</label>
                                                    <input type="number" step="any" class="form-control" name="septiembre" value="{{$tratamiento->septiembre}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Octubre</label>
                                                    <input type="number" step="any" class="form-control" name="octubre" value="{{$tratamiento->octubre}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Noviembre</label>
                                                    <input type="number" step="any" class="form-control" name="noviembre" value="{{$tratamiento->noviembre}}">
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Diciembre</label>
                                                    <input type="number" step="any" class="form-control" name="diciembre" value="{{$tratamiento->diciembre}}">
                                                </div>
                                            </div>
                                        </div>




                                        <button type="submit" class="btn btn-primary  btn-block"> <i class="fa fa-refresh" aria-hidden="true"></i> Actualizar </button>

                                    </form>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </div>
    <!-- Column -->
</div>

@endsection