@extends('layouts.admin')

@section('content')


<div class="containre-fluid">
    <div class="row justify-content-center">

        @can('tratamiento_report')
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    Tratamientos
                </div>
                <div class="card-body text-center">
                    <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/list2.png')}}" alt="{{config('app.name')}}">
                    <p class="card-text">Imprime El Reporte de Todos Los Tratamientos</p>
                </div>
                <div class="card-footer text-muted">
                    <a class="btn btn-primary" href="{{route('tratamientos.printAll')}}" target="_blank" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
        @endcan


        @can('pagodoctor_report')
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    Porcentajes de Pago
                </div>
                <div class="card-body text-center">
                    <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/list3.png')}}" alt="{{config('app.name')}}">
                    <p class="card-text">Imprime Un Listado de Como Pagar Tratamientos a los Doctores / Con Ganancia de Clinica</p>
                </div>
                <div class="card-footer text-muted">
                    <a class="btn btn-primary" href="{{route('pagos.reportPagos')}}" target="_blank" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
        @endcan

        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    Tratamientos Historial
                </div>
                <div class="card-body text-center">

                    <form action="{{route('tratamientos.masToMinus')}}" method="get">
                        @csrf
                        <div class="form-group">
                            <label for="">Fecha De Inicio</label>
                            <input type="date" name="inicio" class="form-control datepicker">
                        </div>
                        <div class="form-group">
                            <label for="">Fecha Final</label>
                            <input type="date" name="fin" class="form-control datepicker">
                        </div>
                        <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>

                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    Tratamientos Historial de Faltantes
                </div>
                <div class="card-body text-center">

                    <form action="{{route('tratamientos.faltantesOperacion')}}" method="get">

                        <select name="tratamiento_id" id="idcliente">
                            @foreach ($tratamiento as $t)
                            <option value="{{$t->id}}">{{$t->nombre}} , {{$t->descripcion}}</option>
                            @endforeach
                        </select>
                        <div class="form-group">
                            <label for="">Fecha De Inicio</label>
                            <input type="date" name="inicio" class="form-control datepicker">
                        </div>
                        <div class="form-group">
                            <label for="">Fecha Final</label>
                            <input type="date" name="fin" class="form-control datepicker">
                        </div>

                        <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>

                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    Tratamientos Con Totales
                </div>
                <div class="card-body text-center">

                    <form action="{{route('tratamientos.totalTratamiento')}}" method="get">

                        <select name="tratamiento_id" id="idcliente2">
                            <option value="TODO">TODOS</option>
                            @foreach ($tratamiento as $t)
                            <option value="{{$t->id}}">{{$t->nombre}} , {{$t->descripcion}}</option>
                            @endforeach
                        </select>
                        <div class="form-group">
                            <label for="">Fecha De Inicio</label>
                            <input type="date" name="inicio" class="form-control datepicker">
                        </div>
                        <div class="form-group">
                            <label for="">Fecha Final</label>
                            <input type="date" name="fin" class="form-control datepicker">
                        </div>

                        <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>

                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">SALIDAS DE INSUMOS / TRATMIENTOS</h4>

                    <br>
                    <form action="{{route('tratamientos.salidadeinsumoentratamiento')}}" method="get">

                        <div class="form-group">
                            <label for="">Fecha De Inicio</label>
                            <input type="date" name="inicio" class="form-control datepicker">
                        </div>
                        <div class="form-group">
                            <label for="">Fecha Final</label>
                            <input type="date" name="fin" class="form-control datepicker">
                        </div>

                        <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>

                    </form>
                </div>
            </div>
        </div>

    </div>
</div>


@endsection


@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection


@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>

<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#idcliente',
            placeholder: 'SELECCIONES SU TRATAMIENTO',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);

    setTimeout(function() {
        new SlimSelect({
            select: '#idcliente2',
            placeholder: 'SELECCIONES SU TRATAMIENTO',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);
</script>
@endsection