@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <span id="card_title" style="font-size: 172%; color: white;">
                            {{ __('Tratamientos') }}
                        </span>

                        @can('tratamiento_store')
                        <div class="float-right">
                            <a href="{{ route('tratamiento.create') }}" class="btn btn-primary  float-right" data-placement="left">
                                {{ __('Registrar Nuevo Tratamiento') }}
                            </a>
                        </div>
                        @endcan

                    </div>
                </div>
                @if ($message = Session::get('success'))
                <div class="alert alert-success">
                    <p>{{ $message }}</p>
                </div>
                @endif

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                            <thead class="thead">
                                <tr>
                                    <th>No</th>
                                    <th>Nombre</th>
                                    <th>Descripción</th>
                                    <th>Precio</th>
                                    <th>Descripción Interna</th>
                                    <th>Tipo</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($tratamientos as $tratamiento)
                                <tr>
                                    <td>{{ $tratamiento->id }}</td>
                                    <td>{{ $tratamiento->nombre }}</td>
                                    <td>{{ $tratamiento->descripcion }}</td>

                                    <td>Q. {{ number_format($tratamiento->precio, 2) }}</td>
                                    <td>{{ $tratamiento->descripcion_interna }}</td>
                                    <td>{{ $tratamiento->tipo }}</td>
                                    <td>

                                        @can('tratamiento_update')
                                        <a class="btn btn-sm btn-primary " href="{{ route('tratamiento.show',$tratamiento->id) }}"><i class="fa fa-fw fa-eye"></i> </a>
                                        @endcan

                                        @can('tratamiento_delete')
                                        <form action="{{ route('tratamiento.destroy',$tratamiento->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Estas Seguro?')"><i class="fa fa-fw fa-trash"></i> </button>
                                        </form>
                                        @endcan

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection