@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <span id="card_title" style="font-size: 172%; color: white;">
                            {{ __('SOLICITUDES DE COMPRAS') }}
                        </span>

                        <div class="float-right">
                            <!-- Button trigger modal -->
                            <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#modelId">
                                NUEVA SOLICITUD
                            </button>

                            <!-- Modal -->
                            <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">NUEVA SOLICITUD</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <form action="{{route('soli.store')}}" method="post">
                                                <div class="container-fluid">

                                                    @csrf

                                                    <div class="form-group">
                                                        <label for="">SOLICITANTE</label>
                                                        <input type="text" class="form-control" name="solicitante" value="{{Auth::user()->name}}" readonly>
                                                    </div>

                                                    <div class="form-group">
                                                        <label for="">ARTICULO</label>
                                                        <input type="text" class="form-control" name="articulo" id="articulo" placeholder="Ingrese Articulo">

                                                    </div>

                                                    <div class="form-group">
                                                        <label for="">DATOS DE COMPRA</label>
                                                        <textarea class="form-control" name="datos" rows="3">Cantidad:
Tipo:
Total de Compra:
Precio de Aprobación:
</textarea>

                                                    </div>

                                                </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-success"><i class="fas fa-save    "></i> GUARDAR</button>
                                        </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <script>
                                $('#exampleModal').on('show.bs.modal', event => {
                                    var button = $(event.relatedTarget);
                                    var modal = $(this);
                                    // Use above variables to manipulate the DOM

                                });
                            </script>
                        </div>
                    </div>
                </div>


                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                            <thead class="thead">
                                <tr>
                                    <th>No</th>

                                    <th>SOLICITANTE</th>

                                    <th>ESTADO</th>
                                    <th>APROBADO POR</th>
                                    <th>Fecha de Registro</th>
                                    <th>Fecha de Aprobación</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $soli)
                                <tr>
                                    <td style="width: 5%;">{{ $soli->id }}</td>
                                    <td style="width: 10%;">{{ $soli->solicitante }}</td>
                                    <td style="width: 10%;">{{ $soli->estado }}</td>
                                    <td style="width: 15%;">{{ $soli->aprovo }}</td>
                                    <td style="width: 10%;">{{ $soli->created_at }}</td>
                                    <td style="width: 10%;">
                                        <?php
                                        if ($soli->updated_at != $soli->created_at) {
                                            echo $soli->updated_at;
                                        }
                                        ?>
                                    </td>
                                    <td style="width: 35%;">
                                        @can('SOLICITUD')
                                        <form action="{{route('soli.update', $soli->id)}}" method="post">
                                            @csrf
                                            @method('put')
                                            <div class="form-group">
                                                <label for=""></label>
                                                <textarea class="form-control" name="datos" id="" rows="4">{{$soli->datos}}</textarea>
                                            </div>
                                            <button type="submit" class="btn btn-warning"><i class="fa fa-check" aria-hidden="true"></i></button>
                                        </form>
                                        @endcan

                                        <form action="{{ route('soli.delete',$soli->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Estas Seguro?')"><i class="fa fa-fw fa-trash"></i> </button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection



@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/slim-select/slimselect.min.js') }}"></script>
<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#articulo',
            placeholder: 'SELECCIONE MULTIPLES RECETAS PARA SU PACIENTE',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);

    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection