@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')

<div class="row">
    <div class="col card p-4">

        <div class="d-flex justify-content-around">
            <div>
                RECORDATORIOS GENERALES
            </div>
            <div>
                <a class="btn btn-primary" href="{{route('reco.create')}}" role="button">NUEVO RECORDATORIO</a>
            </div>
        </div>

        <div class="table-responsive  table-responsive-data2 m-b-30">
            <table class="table  table-hover " id="table_id" data-page-length="15">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Descripción </th>
                        <th>Dias antes Recordar</th>
                        <th>Fecha de Recordatorio</th>
                        <th>Fecha de Registro</th>
                        <th> </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $d)
                    <tr class="tr-shadow ">
                        <td>{{$d->id}}</td>
                        <td>{{$d->descripcion}}</td>
                        <td>{{$d->dias}}</td>
                        <td>{{$d->fecha}}</td>
                        <td>{{$d->created_at}}</td>
                        <td>
                            <div class="table-data-feature">

                                <form action="{{route('reco.delete', ['id' => $d->id])}}" method="post">
                                    @method('DELETE')
                                    @csrf()
                                    <a class="item btn btn-primary" href="{{route('reco.edit', ['id' => $d->id])}}">
                                        <i class="fas fa-edit    "></i>
                                    </a>

                                    <button type="submit" class="item btn btn-danger" onclick=" return  confirm('¿Esta Seguro de Eliminar?')">
                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection