@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection



@section('content')
<div class="container-fluid mb-5">

    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">REGISTRAR RECETA PARA PACIENTE</h4>

                    <form action="{{route('receta.recetarStore')}}" method="post">
                        @csrf

                        <div class="form-group">
                            <br>
                            <label for="">RECETAS</label>
                            <select id="select" name="receta_id[]" multiple required>
                                @foreach ($recetas as $receta)
                                <option value="{{$receta->id}}"><?php echo $receta->nombre ?></option>
                                @endforeach
                            </select>
                        </div>


                        <div class="form-group">
                            <label for="">PACIENTES</label>
                            <select id="paciente" name="paciente_id" required>
                                @foreach ($pacientes as $paciente)
                                <option value="{{$paciente->id}}">{{$paciente->nombre}} / {{$paciente->direccion}}</option>
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary">REGISTRAR</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">RECETAS PARA PACIENTES</h4>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="thead-inverse">
                                <tr>
                                    <th>#</th>
                                    <th>PACIENTE</th>
                                    <th>FECHA DE ASIGNACIÓN</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($recetasPac as $receta)
                                <tr>
                                    <td>{{$receta->id}}</td>
                                    <td>{{$receta->nombre}}</td>
                                    <td>{{$receta->created_at}}</td>
                                    <td>

                                        <a class="btn btn-dark btn-sm" href="{{route('receta.printRecetaDos', ['fecha' => $receta->created_at ])}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i> </a>

                                        <a class="btn btn-info btn-sm" href="{{route('receta.printReceta', ['fecha' => $receta->created_at ])}}"> <i class="fa fa-print"></i> </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        {{$recetasPac->links()}}
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>

<script>
    setTimeout(function() {
        new SlimSelect({
            select: '#select',
            placeholder: 'SELECCIONE MULTIPLES RECETAS PARA SU PACIENTE',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);

    setTimeout(function() {
        new SlimSelect({
            select: '#paciente',
            placeholder: 'SELECCIONE SU PACIENTE',
            deselectLabel: '<span>&times;</span>',
            hideSelectedOption: true,
        })
    }, 300);
</script>
@endsection