@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">


            <p>
                <a class="btn btn-primary" data-toggle="collapse" href="#contentId" aria-expanded="false" aria-controls="contentId">
                    NUEVA RECETA
                </a>
            </p>
            <div class="collapse" id="contentId">
                <form action="{{route('receta.store')}}" method="post">
                    @csrf
                    <div class="form-group">
                        <label for=""></label>
                        <textarea class="form-control" name="nombre" rows="3" id="editor1" placeholder="DATOS DE RECETAS"></textarea>
                    </div>

                    <button type="submit" class="btn btn-primary">GUARDAR</button>

                </form>
            </div>


            <table class="table table-hover" id="table_id" data-page-length="15">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Receta</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recetas as $receta)
                    <tr>
                        <td class="text-uppercase">{{$receta->id}}</td>
                        <td><?php echo $receta->nombre ?></td>
                        <td class="text-uppercase">
                            <form action="{{route('receta.delete', $receta->id)}}" method="post" enctype="multipart/form-data">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger" type="submit" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO HAY DATOS',
                'zeroRecords': 'NO HAY DATOS IGUALES'
            }
        });
    });
</script>


<script src="{{ asset('plugins/ckeditor/ckeditor.js')  }}"></script>
<script>
    CKEDITOR.replace('editor1');
</script>
@endsection