@extends('layouts.admin')


@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">


            <div class="card">
                <div class="card-header">
                    Actualizar Datos
                </div>
                <div class="card-body text-center">

                    <p class="card-text text-capitalize"><b>Tratamiento: </b> {{$pago->tratamiento}}</p>
                    <p class="card-text"><b>Tipo: </b> {{$pago->tipo}}</p>
                    <p class="card-text"><b>Doctor: </b> {{$pago->doctor}}</p>
                    <p class="card-text"><b>Porcentaje: </b> {{number_format($pago->porcentaje, 2)}} %
                    </p>
                    <p class="card-text"><b>Precio de Tratamiento: </b> Q {{number_format($pago->precio, 2)}} </p>
                    <p>
                        <b>Total a Pagar: Q. </b>
                        <span class="badge badge-info" style="font-size: 128%;"><b></b> {{number_format($pagoDoctor, 2)}}</span>
                    </p>

                    <p>
                        <b>
                            Total Ganancia de Clínica: Q.
                        </b>
                        <span class="badge badge-info" style="font-size: 128%;">
                            {{number_format($gananciaClinica, 2)}}</span>
                        </b>
                    </p>

                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#modelId">
                        Modificar Porcentaje
                    </button>


                    <!-- Modal -->
                    <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Modificar Porcentaje</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{route('pagos.update', $pago->id)}}" method="post">
                                    @csrf
                                    @method('PUT')
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <label for="">Porcentaje</label>
                                            <input type="nummer"
                                                class="form-control" step="any" name="porcentaje" value="{{$pago->porcentaje}}">

                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                                        <button type="submit" class="btn btn-primary">Save</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>


                </div>
            </div>


        </div>
    </div>
</div>

@endsection