@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-header">

                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <p class="h3">Tipo de Pago A Doctores</p>

                        <div class="float-right">
                            @can('pagosfactura_store')
                            <a href="{{ route('pagos.create') }}" class="btn btn-primary  float-right" data-placement="left">
                                {{ __('Registrar Nuevo Tipo de Pago') }}
                            </a>
                            @endcan
                        </div>
                    </div>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover " id="table1">
                            <thead class="thead-inverse">
                                <tr>
                                    <th>#</th>
                                    <th>Tratamiento</th>
                                    <th>Precio Publico</th>
                                    <th>Tipo</th>
                                    <th>Doctor</th>
                                    <th>Porcentaje / Monto</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pagos as $pago)
                                <tr>
                                    <td>{{$pago->id}}</td>
                                    <td class="text-capitalize">{{$pago->tratamiento}}</td>
                                    <td>Q. {{number_format($pago->precio, 2)}}</td>
                                    <td>{{$pago->tipo}}</td>
                                    <td>{{$pago->doctor}}</td>
                                    <td>{{number_format($pago->porcentaje, 2)}} % / Q. {{number_format($pago->monto, 2)}}</td>
                                    <td>

                                        <a class="btn btn-info" href="{{route('pagos.show', $pago->id)}}"> <i class="fa fa-eye" aria-hidden="true"></i></a>

                                        @can('pagosfactura_delete')
                                        <form action="{{route('pagos.destroy', $pago->id)}}" method="post">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" onclick="return confirm('¿Esta Seguro de Elimiar ?')" class="btn btn-danger"> <i class="fa fa-trash-o" aria-hidden="true"></i></button>
                                        </form>
                                        @endcan

                                    </td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection


@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table1').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection