@extends('layouts.app')

@section('styles')
<style>
    /* input {
      border-radius: 25px !important;
      border: 2px solid #0d395e !important;
   }

   textarea {
      border-radius: 25px IMP !important;
      border: 2px solid #0d395e !important;
   }

   .form-check [type=checkbox] {
      left: 0px !important;
   } */

    #canvas {
        border: 1px solid black;
        border-radius: 4px !important;
    }
</style>
@endsection

@section('content')

<div class="card">
    <div class="card-body">
        <h4 class="card-title text-center">REGISTRO DE PACIENTE</h4>


        <form method="POST" id="signup-form" action="{{ route('pacientes.registroPrivadoStore') }}" role="form" enctype="multipart/form-data">
            @csrf

            <input type="hidden" value="PRIVADO" name="tipo">
            <input type="hidden" value="ACTIVO" name="estado">
            <input type="hidden" name="aut9" value="odontologia">


            @include('admin.pacientes.forms.create')

            <button type="submit" class="btn btn-success"> <i class="fas fa-save    "></i> GUARDAR</button>


        </form>


    </div>
</div>

@endsection

@section('scripts')

<script>
    const $canvas = document.querySelector("#canvas"),
        $btnDescargar = document.querySelector("#btnDescargar"),
        $btnLimpiar = document.querySelector("#btnLimpiar"),
        $btnGenerarDocumento = document.querySelector("#btnGenerarDocumento");
    const contexto = $canvas.getContext("2d");
    const COLOR_PINCEL = "blue";
    const COLOR_FONDO = "white";
    const GROSOR = 2;
    let xAnterior = 0,
        yAnterior = 0,
        xActual = 0,
        yActual = 0;
    const obtenerXReal = (clientX) => clientX - $canvas.getBoundingClientRect().left;
    const obtenerYReal = (clientY) => clientY - $canvas.getBoundingClientRect().top;
    let haComenzadoDibujo = false; // Bandera que indica si el usuario está presionando el botón del mouse sin soltarlo


    const limpiarCanvas = () => {
        // Colocar color blanco en fondo de canvas
        contexto.fillStyle = COLOR_FONDO;
        contexto.fillRect(0, 0, $canvas.width, $canvas.height);
    };
    limpiarCanvas();
    $btnLimpiar.onclick = limpiarCanvas;
    // Escuchar clic del botón para descargar el canvas
    $btnDescargar.onclick = () => {
        const enlace = document.createElement('a');
        // El título
        enlace.download = "Firma.png";
        // Convertir la imagen a Base64 y ponerlo en el enlace
        enlace.href = $canvas.toDataURL();
        // Hacer click en él
        enlace.click();
    };

    window.obtenerImagen = () => {
        return $canvas.toDataURL();
    };

    $btnGenerarDocumento.onclick = () => {
        window.open("documento.html");
    };
    // Lo demás tiene que ver con pintar sobre el canvas en los eventos del mouse
    $canvas.addEventListener("mousedown", evento => {
        // En este evento solo se ha iniciado el clic, así que dibujamos un punto
        xAnterior = xActual;
        yAnterior = yActual;
        xActual = obtenerXReal(evento.clientX);
        yActual = obtenerYReal(evento.clientY);
        contexto.beginPath();
        contexto.fillStyle = COLOR_PINCEL;
        contexto.fillRect(xActual, yActual, GROSOR, GROSOR);
        contexto.closePath();
        // Y establecemos la bandera
        haComenzadoDibujo = true;
    });

    $canvas.addEventListener("mousemove", (evento) => {
        if (!haComenzadoDibujo) {
            return;
        }
        // El mouse se está moviendo y el usuario está presionando el botón, así que dibujamos todo

        xAnterior = xActual;
        yAnterior = yActual;
        xActual = obtenerXReal(evento.clientX);
        yActual = obtenerYReal(evento.clientY);
        contexto.beginPath();
        contexto.moveTo(xAnterior, yAnterior);
        contexto.lineTo(xActual, yActual);
        contexto.strokeStyle = COLOR_PINCEL;
        contexto.lineWidth = GROSOR;
        contexto.stroke();
        contexto.closePath();
    });
    ["mouseup", "mouseout"].forEach(nombreDeEvento => {
        $canvas.addEventListener(nombreDeEvento, () => {
            haComenzadoDibujo = false;
        });
    });



    // Activamos touchEvent para nuestra pagina
    $canvas.addEventListener("touchstart", function(e) {
        mousePos = getTouchPos(canvas, e);
        console.log(mousePos);
        e.preventDefault(); // Prevent scrolling when touching the canvas
        var touch = e.touches[0];
        var mouseEvent = new MouseEvent("mousedown", {
            clientX: touch.clientX,
            clientY: touch.clientY
        });
        $canvas.dispatchEvent(mouseEvent);
    }, false);
    $canvas.addEventListener("touchend", function(e) {
        e.preventDefault(); // Prevent scrolling when touching the canvas
        var mouseEvent = new MouseEvent("mouseup", {});
        canvas.dispatchEvent(mouseEvent);
    }, false);
    $canvas.addEventListener("touchleave", function(e) {
        // Realiza el mismo proceso que touchend en caso de que el dedo se deslice fuera del canvas
        e.preventDefault(); // Prevent scrolling when touching the canvas
        var mouseEvent = new MouseEvent("mouseup", {});
        canvas.dispatchEvent(mouseEvent);
    }, false);
    $canvas.addEventListener("touchmove", function(e) {
        e.preventDefault(); // Prevent scrolling when touching the canvas
        var touch = e.touches[0];
        var mouseEvent = new MouseEvent("mousemove", {
            clientX: touch.clientX,
            clientY: touch.clientY
        });
        $canvas.dispatchEvent(mouseEvent);
    }, false);

    // Get the position of the mouse relative to the canvas
    function getMousePos(canvasDom, mouseEvent) {
        var rect = canvasDom.getBoundingClientRect();
        /*
          Devuelve el tamaño de un elemento y su posición relativa respecto
          a la ventana de visualización (viewport).
        */
        return {
            x: mouseEvent.clientX - rect.left,
            y: mouseEvent.clientY - rect.top
        };
    }

    // Get the position of a touch relative to the canvas
    function getTouchPos(canvasDom, touchEvent) {
        var rect = canvasDom.getBoundingClientRect();
        console.log(touchEvent);
        /*
          Devuelve el tamaño de un elemento y su posición relativa respecto
          a la ventana de visualización (viewport).
        */
        return {
            x: touchEvent.touches[0].clientX - rect.left, // Popiedad de todo evento Touch
            y: touchEvent.touches[0].clientY - rect.top
        };
    }

    // Draw to the canvas
    function renderCanvas() {
        if (drawing) {
            var tint = document.getElementById("color");
            var punta = document.getElementById("puntero");
            ctx.strokeStyle = tint.value;
            ctx.beginPath();
            ctx.moveTo(lastPos.x, lastPos.y);
            ctx.lineTo(mousePos.x, mousePos.y);
            console.log(punta.value);
            ctx.lineWidth = punta.value;
            ctx.stroke();
            ctx.closePath();
            lastPos = mousePos;
        }
    }
</script>


@endsection