<!doctype html>
<html lang="es">

<head>
    <title>Registro Privado</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
        }

        .form-section-title {
            color: #0d6efd;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
            margin-bottom: 20px;
            margin-top: 30px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: 1.1rem;
        }

        /* Estilos Canvas Firma */
        #canvas {
            border: 2px dashed #adb5bd;
            border-radius: 10px;
            background-color: #fff;
            cursor: crosshair;
            /* width: 100%; */
            touch-action: none;
            /* Vital para móviles */
        }

        /* Estilos Webcam Container */
        #webcam-container {
            position: relative;
            background-color: #000;
            border-radius: 10px;
            overflow: hidden;
            width: 100%;
            max-width: 500px;
            height: 375px;
            /* Altura fija para mantener aspecto */
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #webcam-stream,
        #photo-preview {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .placeholder-camera {
            color: #6c757d;
            text-align: center;
        }
    </style>
</head>

<body>

    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">

                <div class="card card-custom">
                    <div class="card-header bg-primary text-white text-center py-4" style="border-radius: 15px 15px 0 0;">
                        <h4 class="mb-0 fw-bold"><i class="fas fa-hospital-user me-2"></i> REGISTRO DE PACIENTE</h4>
                        <small>CIRUGÍA ESTÉTICA Y MAXILOFACIAL (PRIVADO)</small>
                    </div>

                    <div class="card-body p-4 p-md-5">

                        <form method="POST" id="signup-form" action="{{ route('pacientes.registroPrivadoStore') }}" enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="aut9" value="maxilo">
                            <input type="hidden" value="PRIVADO" name="tipo">
                            <input type="hidden" value="ACTIVO" name="estado">

                            <input type="hidden" name="firma_base64" id="firma_base64">
                            <input type="hidden" name="webcam_image" id="webcam-image-data">

                            <h5 class="form-section-title"><i class="fas fa-user me-2"></i> Datos Personales</h5>

                            <div class="row g-3">
                                <div class="col-md-8">
                                    <label class="form-label fw-bold text-muted small">NOMBRE COMPLETO</label>
                                    <input type="text" class="form-control" name="nombre" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-bold text-muted small">FECHA NACIMIENTO</label>
                                    <input type="date" class="form-control" name="fecha_nacimiento" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-bold text-muted small">DPI</label>
                                    <input type="text" class="form-control" name="dpi" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-bold text-muted small">SEXO</label>
                                    <select class="form-select" name="sexo" required>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Femenino">Femenino</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-bold text-muted small">ESTADO CIVIL</label>
                                    <select class="form-select" name="civil" required>
                                        <option value="Soltero(a)">Soltero(a)</option>
                                        <option value="Casado(a)">Casado(a)</option>
                                        <option value="Union De Hecho">Unión De Hecho</option>
                                        <option value="Viudo(a)">Viudo(a)</option>
                                        <option value="Divorciado (a)">Divorciado (a)</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-bold text-muted small">OCUPACIÓN</label>
                                    <input type="text" class="form-control" name="ocupacion" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-bold text-muted small">TELÉFONO</label>
                                    <input type="text" class="form-control" name="telefono" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-bold text-muted small">DIRECCIÓN</label>
                                    <input type="text" class="form-control" name="direccion" required>
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-bold text-muted small">MOTIVO CONSULTA</label>
                                    <input type="text" class="form-control" name="aut1">
                                </div>
                            </div>

                            <h5 class="form-section-title"><i class="fas fa-user-shield me-2"></i> Datos Encargado</h5>
                            <div class="card bg-light border-0 p-3 mb-3">
                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="nombre_en" placeholder="Nombre Encargado">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="relacion_en" placeholder="Relación">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="number" class="form-control" name="edad_en" placeholder="Edad">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="dpi_en" placeholder="DPI Encargado">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="telefono_en" placeholder="Teléfono">
                                    </div>
                                    <div class="col-12">
                                        <input type="text" class="form-control" name="direccion_en" placeholder="Dirección Encargado">
                                    </div>
                                </div>
                            </div>

                            <h5 class="form-section-title"><i class="fas fa-camera me-2"></i> Fotografía del Paciente</h5>

                            <div class="row justify-content-center">
                                <div class="col-md-8 text-center">
                                    <div id="webcam-container" class="shadow-sm mb-3">
                                        <div id="camera-placeholder" class="placeholder-camera">
                                            <i class="fas fa-camera fa-3x mb-2"></i>
                                            <p>Cámara inactiva</p>
                                        </div>
                                        <video id="webcam-stream" autoplay playsinline style="display: none;"></video>
                                        <img id="photo-preview" src="" style="display: none;">
                                    </div>

                                    <div class="btn-group shadow-sm" role="group">
                                        <button type="button" class="btn btn-outline-primary" id="start-webcam-button">
                                            <i class="fas fa-power-off me-1"></i> Iniciar
                                        </button>
                                        <button type="button" class="btn btn-primary" id="take-photo-button" disabled>
                                            <i class="fas fa-camera me-1"></i> Capturar
                                        </button>
                                        <button type="button" class="btn btn-outline-danger" id="stop-webcam-button" disabled>
                                            <i class="fas fa-stop me-1"></i> Detener
                                        </button>
                                    </div>
                                    <div id="webcam-error" class="text-danger mt-2 small"></div>

                                    <canvas id="canvas2" style="display:none;"></canvas>
                                </div>
                            </div>

                            <h5 class="form-section-title"><i class="fas fa-signature me-2"></i> Firma del Paciente</h5>

                            <div class="row justify-content-center">
                                <div class="col-md-8 text-center">
                                    <p class="text-muted small mb-2">Firme en el recuadro blanco:</p>

                                    <canvas id="canvas" height="200"></canvas>

                                    <div class="mt-2 d-flex justify-content-center gap-2">
                                        <button type="button" class="btn btn-secondary btn-sm" id="btnLimpiar">
                                            <i class="fas fa-eraser"></i> Borrar Firma
                                        </button>
                                    </div>

                                    <div class="mt-3 pt-3 border-top">
                                        <label class="form-label small fw-bold text-muted">O suba una imagen de la firma:</label>
                                        <input type="file" class="form-control form-control-sm" name="firma2" accept="image/*">
                                    </div>
                                </div>
                            </div>

                            <hr class="my-5">

                            <div class="d-grid gap-2 col-md-6 mx-auto">
                                <button type="submit" class="btn btn-success btn-lg rounded-pill shadow">
                                    <i class="fas fa-save me-2"></i> GUARDAR REGISTRO
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {

            // ==========================================
            // 1. LÓGICA DE FIRMA (CANVAS)
            // ==========================================
            const $canvas = document.querySelector("#canvas");
            const $btnLimpiar = document.querySelector("#btnLimpiar");
            const contexto = $canvas.getContext("2d");
            let dibujando = false;

            // Ajustar resolución del canvas para que no se vea pixelado (opcional pero recomendado)
            // $canvas.width = $canvas.offsetWidth;
            // $canvas.height = 200;

            const limpiarCanvas = () => {
                contexto.fillStyle = "white";
                contexto.fillRect(0, 0, $canvas.width, $canvas.height);
                contexto.beginPath();
            };
            limpiarCanvas(); // Inicializar blanco
            $btnLimpiar.onclick = limpiarCanvas;

            // Funciones de dibujo
            const obtenerPos = (e) => {
                const rect = $canvas.getBoundingClientRect();
                const clientX = e.touches ? e.touches[0].clientX : e.clientX;
                const clientY = e.touches ? e.touches[0].clientY : e.clientY;
                return {
                    x: clientX - rect.left,
                    y: clientY - rect.top
                };
            };

            const empezarDibujo = (e) => {
                dibujando = true;
                const pos = obtenerPos(e);
                contexto.beginPath();
                contexto.moveTo(pos.x, pos.y);
                e.preventDefault(); // Evitar scroll en móvil
            };

            const dibujar = (e) => {
                if (!dibujando) return;
                const pos = obtenerPos(e);
                contexto.lineTo(pos.x, pos.y);
                contexto.strokeStyle = "blue";
                contexto.lineWidth = 2;
                contexto.stroke();
                e.preventDefault();
            };

            const terminarDibujo = () => {
                dibujando = false;
            };

            // Eventos Mouse
            $canvas.addEventListener("mousedown", empezarDibujo);
            $canvas.addEventListener("mousemove", dibujar);
            $canvas.addEventListener("mouseup", terminarDibujo);
            $canvas.addEventListener("mouseout", terminarDibujo);

            // Eventos Touch
            $canvas.addEventListener("touchstart", empezarDibujo, {
                passive: false
            });
            $canvas.addEventListener("touchmove", dibujar, {
                passive: false
            });
            $canvas.addEventListener("touchend", terminarDibujo);


            // ==========================================
            // 2. LÓGICA DE WEBCAM
            // ==========================================
            const video = document.getElementById('webcam-stream');
            const photoPreview = document.getElementById('photo-preview');
            const placeholder = document.getElementById('camera-placeholder');
            const webcamInput = document.getElementById('webcam-image-data');
            const btnStart = document.getElementById('start-webcam-button');
            const btnTake = document.getElementById('take-photo-button');
            const btnStop = document.getElementById('stop-webcam-button');
            const canvasWebcam = document.getElementById('canvas2');
            let stream;

            // Iniciar Cámara
            btnStart.addEventListener('click', async () => {
                try {
                    stream = await navigator.mediaDevices.getUserMedia({
                        video: true,
                        audio: false
                    });
                    video.srcObject = stream;
                    video.style.display = 'block';
                    photoPreview.style.display = 'none';
                    placeholder.style.display = 'none';

                    btnStart.disabled = true;
                    btnTake.disabled = false;
                    btnStop.disabled = false;
                } catch (err) {
                    console.error("Error webcam:", err);
                    alert("No se pudo acceder a la cámara.");
                }
            });

            // Tomar Foto
            btnTake.addEventListener('click', () => {
                if (!stream) return;

                // Dimensionar canvas oculto
                canvasWebcam.width = video.videoWidth;
                canvasWebcam.height = video.videoHeight;

                // Dibujar
                const ctx = canvasWebcam.getContext('2d');
                ctx.drawImage(video, 0, 0);

                // Convertir a Base64
                const dataURL = canvasWebcam.toDataURL('image/png');
                webcamInput.value = dataURL; // Guardar en input hidden

                // Mostrar preview
                photoPreview.src = dataURL;
                photoPreview.style.display = 'block';
                video.style.display = 'none';

                // Detener stream opcionalmente o mantenerlo
                stopWebcamLogic();
            });

            // Detener Cámara
            btnStop.addEventListener('click', stopWebcamLogic);

            function stopWebcamLogic() {
                if (stream) {
                    stream.getTracks().forEach(track => track.stop());
                    stream = null;
                }
                video.style.display = 'none';
                // Si hay foto tomada, dejamos el preview, si no, mostramos placeholder
                if (!webcamInput.value) {
                    placeholder.style.display = 'block';
                }

                btnStart.disabled = false;
                btnTake.disabled = true;
                btnStop.disabled = true;
            }


            // ==========================================
            // 3. ENVÍO DEL FORMULARIO
            // ==========================================
            const form = document.getElementById('signup-form');
            const firmaInput = document.getElementById('firma_base64');

            form.addEventListener('submit', function(e) {
                // Antes de enviar, guardamos la firma del canvas en el input hidden
                // Nota: toDataURL por defecto es PNG transparente
                const firmaData = $canvas.toDataURL("image/png");

                // Validamos si el canvas está vacío comparándolo con un canvas vacío
                // (Opcional, pero Laravel ya valida si viene lleno)
                firmaInput.value = firmaData;

                // La imagen de la webcam ya se guardó en 'webcam-image-data' al hacer click en "Capturar"
            });

        });
    </script>
</body>

</html>