@extends('layouts.admin')

@section('styles')

<link rel="stylesheet" href="{{asset('plugins/galeria/galeria.css')}}">
<link rel="stylesheet" href="{{asset('plugins/select2/css/select2.min.css')}}">


<style>
   .input-group-text {
      background-color: white;
      border: none;
   }

   .actualizar {
      color: #64b96b;
   }
</style>
@endsection

@section('content')
<div class="row">

   <!-- Data De Paciente-->
   @include('admin.pacientes.data.datashow')
   <!-- end Data de Paciente -->
   <!-- Column -->
   <div class="col-md-9">
      <div class="card">
         <div class="card-body">

            <div class="text-center">
               <a class="btn btn-info mb-md-4" target="_blank" href="{{route('pac.new_presu', ['id' => $paciente->id])}}">INGRESO A PRESUPUESTO</a>

               <a class="btn btn-info mb-md-4" target="_blank" href="{{route('escan.dpi', ['id' => $paciente->id])}}">ESCANEAR DPI</a>

               <a class="btn btn-info mb-md-4" href="{{route('paciente.setReFirma', ['id' => $paciente->id])}}">ASIGNAR FIRMA</a>



            </div>

            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
               <li class="nav-item">
                  <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">HISTORIAL DE TRATAMIENTO</a>
               </li>

               <li class="nav-item">
                  <a class="nav-link" id="pills-operacion-tab" data-toggle="pill" href="#pills-operacion" role="tab" aria-controls="pills-operacion" aria-selected="false">OPERACIONES</a>
               </li>

               <li class="nav-item">
                  <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">CONSENTIMIENTOS</a>
               </li>

               <li class="nav-item">
                  <a class="nav-link" id="pills-igss-tab" data-toggle="pill" href="#pills-igss" role="tab" aria-controls="pills-igss" aria-selected="false">ENDODONCIA</a>
               </li>

               <li class="nav-item">
                  <a class="nav-link" id="pills-privado-tab" data-toggle="pill" href="#pills-privado" role="tab" aria-controls="pills-privado" aria-selected="false">ESTETICA</a>
               </li>

               <li class="nav-item">
                  <a class="nav-link" id="pills-historial123-tab" data-toggle="pill" href="#pills-historial123" role="tab" aria-controls="pills-historial123" aria-selected="false">HISTORIAL</a>
               </li>
            </ul>

            <div class="tab-content" id="pills-tabContent">
               <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">

                  <div class="row">
                     <div class="col-md-8">
                        @include('admin.pacientes.data.historial')
                     </div>

                     <div class="col-md-2">
                        <p class="text-center">DIARIO</p>
                        @include('admin.pacientes.data.diario')
                     </div>

                  </div>
               </div>

               <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                  @include('admin.pacientes.consentimientos-hojas.consentimientos')
               </div>

               <div class="tab-pane fade" id="pills-operacion" role="tabpanel" aria-labelledby="pills-operacion-tab">
                  @include('admin.pacientes.data.operaciones')
               </div>

               <div class="tab-pane fade" id="pills-privado" role="tabpanel" aria-labelledby="pills-privado-tab">
                  cirugia estetica

               </div>


               <div class="tab-pane fade" id="pills-historial123" role="tabpanel" aria-labelledby="pills-historial123-tab">
                  <!-- historial-->
                  <div class="row">
                     <div class="col-md-12">
                        @include('admin.pacientes.data.historial-rapido')
                     </div>

                  </div>
               </div>


               <div class="tab-pane fade" id="pills-igss" role="tabpanel" aria-labelledby="pills-igss-tab">
                  @include('admin.pacientes.consentimientos-hojas.odontologia')
               </div>

            </div>
         </div>
      </div>
   </div>
</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/galeria/galeria.js')}}"></script>
<script src="{{asset('plugins/select2/js/select2.full.min.js')}}"></script>
@include('admin.pacientes.data.addPresupuesto')
@endsection