@extends('layouts.admin')

@section('content')

<div class="containre-fluid">
   <div class="row justify-content-center">

      <div class="col-md-4">
         <div class="card">
            <div class="card-header">
               Pacientes
            </div>
            <div class="card-body text-center">
               <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/patient.png')}}" alt="{{config('app.name')}}">
               <p class="card-text">Imprimer El Reporte de Todos Los Pacientes</p>
            </div>
            <div class="card-footer text-muted">
               <a class="btn btn-primary" target="_blank" href="{{route('pacientes.reportall')}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
            </div>
         </div>
      </div>

      <div class="col-md-4">
         <div class="card">
            <div class="card-header">
               Pacientes Activos
            </div>
            <div class="card-body text-center">
               <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/tooth.png')}}" alt="{{config('app.name')}}">
               <p class="card-text">Imprimer Un Listado de Los Pacientes Activos</p>
            </div>
            <div class="card-footer text-muted">
               <a class="btn btn-primary" target="_blank" href="{{route('pacientes.reportActivos')}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
            </div>
         </div>
      </div>

      <div class="col-md-4">
         <div class="card">
            <div class="card-header">
               Pacientes Inactivos
            </div>
            <div class="card-body text-center">
               <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/tooth2.png')}}" alt="{{config('app.name')}}">
               <p class="card-text">Imprimer Un Listado de Los Pacientes Inactivos</p>
            </div>
            <div class="card-footer text-muted">
               <a class="btn btn-primary" target="_blank" href="{{route('pacientes.reportInactivos')}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
            </div>
         </div>
      </div>

      @can('paciente_deudores')
      <div class="col-md-4">
         <div class="card">
            <div class="card-header">
               Pacientes Deudores
            </div>
            <div class="card-body text-center">
               <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/minus.png')}}" alt="{{config('app.name')}}">
               <p class="card-text">Imprimer Un Listado de Los Pacientes Deudores</p>
            </div>
            <div class="card-footer text-muted">
               <a class="btn btn-primary" target="_blank" href="{{route('pacientes.printDeudores')}}" role="button"> <i class="fa fa-print" aria-hidden="true"></i></a>
            </div>
         </div>
      </div>
      @endcan




   </div>
</div>


@endsection