<!doctype html>
<html lang="es">

<head>
    <title>{{ config('app.name', 'Portal de Pacientes') }}</title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous" />

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
            /* Color de fondo suave */
        }

        .card-option {
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
            height: 100%;
            background: white;
        }

        .card-option:hover {
            transform: translateY(-10px);
            /* Efecto de elevación */
            box-shadow: 0 1rem 3rem rgba(0, 0, 0, 0.175) !important;
            border-bottom: 5px solid #0d6efd;
            /* Línea de color al hacer hover */
        }

        .card-img-wrapper {
            height: 200px;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            background-color: #fafafa;
            border-radius: 1rem 1rem 0 0;
        }

        .card-img-top {
            max-height: 100%;
            width: auto;
            max-width: 80%;
            object-fit: contain;
        }

        a.stretched-link {
            text-decoration: none;
            color: inherit;
        }
    </style>
</head>

<body>

    <div class="d-flex align-items-center min-vh-100">
        <div class="container">

            <div class="row justify-content-center mb-5">
                <div class="col-12 text-center">
                    <h2 class="fw-bold text-primary mb-3">Bienvenido al Portal de Pacientes</h2>
                    <p class="text-muted">Por favor seleccione el tipo de registro que desea realizar</p>
                </div>
            </div>

            <div class="row justify-content-center g-4">
                <div class="col-md-5 col-lg-4">
                    <div class="card card-option shadow-sm rounded-4 h-100 position-relative">
                        <div class="card-img-wrapper">
                            <img class="card-img-top" src="{{asset('assets/images/clinica.png')}}" alt="Icono Clínica">
                        </div>
                        <div class="card-body text-center p-4 d-flex flex-column justify-content-center">
                            <h5 class="card-title fw-bold text-dark mb-3">CIRUGÍA ESTÉTICA Y MAXILOFACIAL</h5>
                            <p class="card-text text-muted small mb-0">Registro para pacientes referidos o consultas especializadas.</p>
                            <a href="{{route('pacientes.registroIgss')}}" class="stretched-link"></a>
                        </div>
                    </div>
                </div>

                <div class="col-md-5 col-lg-4">
                    <div class="card card-option shadow-sm rounded-4 h-100 position-relative">
                        <div class="card-img-wrapper">
                            <img class="card-img-top" src="{{asset('logos/icono.jpg')}}" alt="Icono Privado">
                        </div>
                        <div class="card-body text-center p-4 d-flex flex-column justify-content-center">
                            <h5 class="card-title fw-bold text-dark mb-3">PACIENTE {{config ('app.name', 'Portal de Pacientes')}}</h5>
                            <p class="card-text text-muted small mb-0">Registro general para consulta privada y seguimiento.</p>
                            <a href="{{route('pacientes.registroPrivado')}}" class="stretched-link"></a>
                        </div>
                    </div>
                </div>

            </div>

            <div class="row mt-5">
                <div class="col-12 text-center text-muted small">
                    &copy; {{ date('Y') }} <a href="decodev.net" target="_blank">DeCoDev Servicios Informáticos</a>. Todos los derechos reservados.
                </div>
            </div>

        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"
        integrity="sha384-I7E8VVD/ismYTF4hNIPjVp/Zjvgyol6VFvRkX/vR+Vc4jQkC+hVqc2pM8ODewa9r"
        crossorigin="anonymous"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js"
        integrity="sha384-BBtl+eGJRgqQAUMxJ7pMwbEyER4l1g+O15P+16Ep7Q9Q+zqX6gSbd85u4mG4QzX+"
        crossorigin="anonymous"></script>
</body>

</html>