@extends('layouts.admin')


@section('styles')
<style>
    /* Ejemplo: Fondo amarillo suave y letra negrita */
    .fila-maxilo {
        background-color: #fff3cd !important;
        /* !important ayuda a sobreescribir el estilo base del datatable */
        font-weight: bold;
        color: #856404;
    }

    /* Si usas table-striped de Bootstrap, asegura que el hover se vea bien */
    table.dataTable tbody tr.fila-maxilo:hover {
        background-color: #ffeeba !important;
    }
</style>
@endsection

@section('content')

<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <div style="display: flex; justify-content: space-between; align-items: center;">

                    <span style="font-size: 172%">
                        {{ __('Pacientes') }}
                    </span>


                </div>
            </div>

            @include('includes.alerts')

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                        <thead class="thead">
                            <tr>
                                <th>No</th>

                                <th>Nombre</th>
                                <th>DPI</th>
                                <th>Telefono</th>
                                <th>Direccion</th>
                                <th>Tipo</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@section('scripts')

<!-- Incluye los archivos CSS de DataTables -->
<link rel="stylesheet" href="{{asset('plugins/datatables/buttons.dataTables.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">


<!-- DataTables JS -->
<script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script src="{{asset('plugins/datatables/dataTables.buttons.min.js')}}"></script>


<!-- JSZip (para exportar a Excel) -->
<script src="{{asset('plugins/datatables/jszip.min.js')}}"></script>

<!-- PDFMake (para exportar a PDF) -->
<script src="{{asset('plugins/datatables/pdfmake.min.js')}}"></script>
<script src="{{asset('plugins/datatables/vfs_fonts.js')}}"></script>

<!-- Botones adicionales (Excel, PDF, Print) -->
<script src="{{asset('plugins/datatables/buttons.html5.min.js')}}"></script>
<script src="{{asset('plugins/datatables/buttons.print.min.js')}}"></script>

<!-- fin botones -->


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.11.1/dist/sweetalert2.all.min.js"></script>


<script>
    var ruta = " {{ route('pacientes.getAjaxPaciente') }}";


    $(document).ready(function() {
        var table = $("#table_id").DataTable({
            dom: 'Bfrtip',
            processing: true,
            serverSide: true,
            ajax: ruta,
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],

            // --- AQUÍ ESTÁ EL CAMBIO ---
            createdRow: function(row, data, dataIndex) {
                // Evaluamos si la columna 'tipo' es igual a 'maxilo'
                if (data.aut9 === 'maxilo') {
                    // Opción A: Agregar una clase CSS (Recomendado)
                    $(row).addClass('fila-maxilo');

                    // Opción B: Cambiar estilos directamente (No recomendado pero funciona rápido)
                    // $(row).css('background-color', '#ffcccc');
                }
            },

            columns: [

                {
                    data: "id",
                    name: "id"
                }, {
                    data: "nombre",
                    name: "NOMBRE"
                }, {
                    data: "dpi",
                    name: "DPI"
                }, {
                    data: "telefono",
                    name: "Telefono"
                }, {
                    data: "direccion",
                    name: "Direccion"
                }, {
                    data: "tipo",
                    name: "Tipo"
                },
                {
                    data: null,
                    orderable: false,
                    searchable: false,
                    render: function(data, type, row) {
                        return `
                        <button class="btn btn-sm btn-primary editar" data-id="${row.id}"><i class="fa fa-eye" aria-hidden="true"></i></button>
<button class="btn btn-sm btn-danger eliminar" data-id="${row.id}"><i class="fa fa-trash" aria-hidden="true"></i></button>`;
                    },
                },
            ],
        });


        // Manejador de eventos para el clic en una fila
        $('#table_id tbody').on('click', 'tr', function() {
            var data = table.row(this).data();
            if (data) {
                let ruta = `{{ route('pacientes.show', ':id') }}`

                window.location.href = ruta.replace(':id', data.id); // Reemplaza '/tu-ruta-de-edicion/' con la ruta correcta
            }
        });

    });




    // Manejar eventos de clic en los botones
    $("#table_id").on("click", ".editar", function() {
        var id = $(this).data("id");

        let ruta = `{{ route('pacientes.show', ':id') }}`

        window.location.href = ruta.replace(':id', id);
    });

    $("#table_id").on("click", ".eliminar", function() {
        var id = $(this).data("id");
        var ruta = `{{ route('pacientes.destroy', ':id') }}`
        ruta = ruta.replace(':id', id);
        if (confirm("¿Estás seguro de eliminar este artículo?")) {
            $.ajax({
                url: ruta,
                method: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function() {
                    $("#table_id").DataTable().ajax.reload();
                    Swal.fire({
                        position: "top-end",
                        icon: "success",
                        title: "Exelente, Paciente Eliminado",
                        showConfirmButton: false,
                        timer: 1000,
                        toast: true

                    });
                },
                error: function() {
                    alert("Hubo un error al eliminar el artículo.");
                },
            });
        }
    });
</script>
@endsection