@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <span id="card_title" style="font-size: 172%; color: white;">
                            {{ __('Pacientes Activos') }}
                        </span>

                    </div>
                </div>

                @include('includes.alerts')

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                            <thead class="thead">
                                <tr>
                                    <th>Fecha</th>

                                    <th>Nombre</th>
                                    <th>Email</th>
                                    <th>Tel Casa</th>
                                    <th>Tel Oficina</th>
                                    <th>Tel Celular</th>
                                    <th>Direccion</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pacientes as $paciente)
                                <tr>
                                    <td>
                                        {{ $paciente->updated_at->translatedFormat('d \d\e F \d\e Y') }}

                                    </td>

                                    <td>{{ $paciente->nombre }}</td>
                                    <td>{{ $paciente->email }}</td>
                                    <td>{{ $paciente->t_casa }}</td>
                                    <td>{{ $paciente->t_oficina }}</td>
                                    <td>{{ $paciente->t_celular }}</td>
                                    <td>{{ $paciente->direccion }}</td>
                                    <td>
                                        <a class="btn btn-sm btn-primary " href="{{ route('pacientes.show',$paciente->id) }}"><i class="fa fa-fw fa-eye"></i> </a>

                                        @can('paciente_delete')
                                        <form action="{{ route('pacientes.destroy',$paciente->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('¿Estas Seguro?')"><i class="fa fa-fw fa-trash"></i> </button>
                                        </form>
                                        @endcan

                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection



@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ REGISTROS',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO EXISTEN DATOS',
                'zeroRecords': 'NO EXISTEN DATOS IGUALES'
            }
        });
    });
</script>
@endsection