@extends('layouts.admin')

@section('styles')
<style>
    .form-check [type=checkbox] {
        left: 0px !important;
    }
</style>

<script src="https://cdn.tailwindcss.com"></script>
<style>
    /* Estilo básico para el video y canvas */
    video,
    canvas {
        max-width: 100%;
        /* Asegura que no se desborden */
        height: auto;
        /* Mantiene la proporción */
        border: 1px solid #ccc;
        border-radius: 0.5rem;
        /* Bordes redondeados */
    }
</style>

@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{route('pacientes.update',  $paciente->id)}}" method="post">
                        @csrf
                        @method('PUT')
                        @include('admin.pacientes.forms.edit')




                        <div id="webcam-container">
                            <h3>Previsualización de la Webcam</h3>
                            <video id="webcam-stream" autoplay playsinline style="width: 100%; max-width: 400px;"></video>
                            <div id="webcam-error" style="color: red;"></div>
                        </div>

                        <div id="webcam-controls" style="margin-top: 10px;">
                            <button class="btn btn-info" type="button" id="start-webcam-button" style="display: none;">Iniciar Cámara</button>
                            <button class="btn btn-warning" type="button" id="take-photo-button">Tomar Foto</button>
                            <button class="btn btn-danger" type="button" id="stop-webcam-button">Detener Cámara</button>
                        </div>


                        <input type="hidden" name="webcam_image" id="webcam-image-data">
                        <img id="photo-preview" src="" style="display: none; max-width: 400px; margin-top: 10px;">
                        <canvas id="canvas" style="display:none;"></canvas>



                        <button type="submit" class="btn btn-warning"> <i class="fa fa-refresh" aria-hidden="true"></i> ACTUALIZAR</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('scripts')
<script>
    const video = document.getElementById('webcam-stream');
    const canvas = document.getElementById('canvas');
    const photoPreview = document.getElementById('photo-preview');
    const webcamImageDataInput = document.getElementById('webcam-image-data');
    const webcamErrorDiv = document.getElementById('webcam-error');

    // Nuevos elementos de control
    const startWebcamButton = document.getElementById('start-webcam-button');
    const takePhotoButton = document.getElementById('take-photo-button'); // Este ya existía, pero lo incluimos en las referencias
    const stopWebcamButton = document.getElementById('stop-webcam-button');

    let stream; // Para guardar la referencia al stream de la cámara

    // Función para actualizar el estado de los botones
    function updateButtonState(isWebcamRunning) {
        if (isWebcamRunning) {
            startWebcamButton.style.display = 'inline-block'; // Mostrar botón de iniciar
            takePhotoButton.style.display = 'inline-block'; // Mostrar botón de tomar foto
            stopWebcamButton.style.display = 'inline-block'; // Mostrar botón de detener
            takePhotoButton.disabled = false; // Asegurarse de que el botón de tomar foto esté habilitado
        } else {
            startWebcamButton.style.display = 'inline-block'; // Mostrar botón de iniciar
            takePhotoButton.style.display = 'inline-block'; // Ocultar botón de tomar foto
            stopWebcamButton.style.display = 'inline-block'; // Ocultar botón de detener
            // Mantener takePhotoButton.disabled en false o true según si hay datos en el input oculto?
            // Para simplificar, lo deshabilitamos si no hay stream
            takePhotoButton.disabled = true;
        }
    }

    // Función para iniciar la webcam
    async function startWebcam() {
        try {
            // Limpiar mensajes de error previos
            webcamErrorDiv.textContent = '';
            photoPreview.style.display = 'none'; // Ocultar preview si estaba visible
            photoPreview.src = '';
            webcamImageDataInput.value = ''; // Limpiar datos de imagen previos
            video.style.display = 'block'; // Asegurarse de que el video esté visible

            // Solicitar acceso al stream de video (sin audio)
            stream = await navigator.mediaDevices.getUserMedia({
                video: true,
                audio: false
            });

            // Asignar el stream al elemento de video
            video.srcObject = stream;

            // Esperar a que el video cargue y esté listo para reproducirse
            video.onloadedmetadata = (event) => {
                video.play();
                console.log("Webcam iniciada correctamente.");
                updateButtonState(true); // Actualizar estado de los botones: Webcam corriendo
            };

        } catch (err) {
            // Manejar errores (por ejemplo, usuario denegó el permiso, no hay cámara, etc.)
            console.error("Error al acceder a la webcam:", err);
            webcamErrorDiv.textContent = 'No se pudo acceder a la webcam. Por favor, asegúrate de que esté conectada y que hayas dado permiso.';
            video.style.display = 'none'; // Ocultar el elemento de video si falla
            updateButtonState(false); // Actualizar estado de los botones: Webcam detenida (por error)
        }
    }

    // Función para detener la webcam
    function stopWebcam() {
        if (stream) {
            stream.getTracks().forEach(track => track.stop());
            video.srcObject = null; // Limpiar la fuente del video
            video.style.display = 'none'; // Ocultar el elemento de video
            console.log("Webcam detenida por el usuario.");
            updateButtonState(false); // Actualizar estado de los botones: Webcam detenida
            // Opcional: Puedes limpiar el campo oculto de la imagen si detiene la cámara
            // webcamImageDataInput.value = '';
            // photoPreview.style.display = 'none';
            // photoPreview.src = '';
        }
    }

    // Función para tomar la foto
    function takeSnapshot() {
        if (!stream) {
            console.error("Webcam no está activa para tomar la foto.");
            webcamErrorDiv.textContent = 'La webcam no está activa.';
            return;
        }

        // Asegurarse de que el canvas tenga las dimensiones correctas
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;

        // Dibujar el frame actual del video en el canvas
        const context = canvas.getContext('2d');
        context.drawImage(video, 0, 0, canvas.width, canvas.height);

        // Obtener la imagen del canvas en formato Data URL (Base64)
        const imageDataUrl = canvas.toDataURL('image/png'); // Puedes usar 'image/jpeg'

        // Asignar los datos Base64 al campo oculto del formulario
        webcamImageDataInput.value = imageDataUrl;

        // Mostrar la foto tomada al usuario
        photoPreview.src = imageDataUrl;
        photoPreview.style.display = 'block';
        video.style.display = 'none'; // Ocultar el stream de video después de tomar la foto

        // Puedes detener la webcam automáticamente después de tomar la foto si lo deseas
        // stopWebcam(); // Descomenta esta línea si quieres que se detenga automáticamente

        console.log("Foto tomada y guardada en el campo oculto.");
        stopWebcam();
        webcamErrorDiv.textContent = ''; // Limpiar mensajes de error si había alguno
    }


    // --- Event Listeners ---

    // Iniciar la webcam cuando la página termine de cargar
    // window.addEventListener('load', startWebcam);

    // Detener la webcam al salir de la página (opcional, ayuda a liberar recursos)
    window.addEventListener('beforeunload', stopWebcam);

    // Añadir evento al botón de tomar foto
    takePhotoButton.addEventListener('click', takeSnapshot);

    // Añadir evento al botón de detener cámara
    stopWebcamButton.addEventListener('click', stopWebcam);

    // Añadir evento al botón de iniciar cámara
    startWebcamButton.addEventListener('click', startWebcam);

    // --- Estado Inicial ---
    // Inicialmente, solo mostramos el botón de "Iniciar Cámara" y deshabilitamos "Tomar Foto" y "Detener"
    // La función startWebcam llamará a updateButtonState(true) si tiene éxito.
    updateButtonState(false); // Establecer estado inicial: Webcam detenida
</script>
@endsection