@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         <div class="card">
            <div class="card-header">
               <div style="display: flex; justify-content: space-between; align-items: center;">
                  <span style="font-size: 172%">
                     {{ __('Pacientes') }}
                  </span>
               </div>
            </div>

            <div class="card-body">
               <div class="table-responsive">
                  <table class="table table-striped table-hover" id="table_id" data-page-length="15">
                     <thead class="thead">
                        <tr>
                           <th>No</th>

                           <th>Nombre</th>
                           <th>Telefono</th>
                           <th>Telefono Encargado</th>
                           <th>Direccion</th>
                           <th>Tipo</th>
                           <th>Total Adeudada</th>
                           <th></th>
                        </tr>
                     </thead>
                     <tbody>
                        @for($i = 0; $i < count($pacientes);$i++) <tr>
                           <td>{{ $pacientes[$i]->id }}</td>
                           <td>{{ $pacientes[$i]->nombre }}</td>
                           <td>{{ $pacientes[$i]->telefono }}</td>
                           <td>{{ $pacientes[$i]->telefono_en }}</td>
                           <td>{{ $pacientes[$i]->direccion }}</td>
                           <td>{{ $pacientes[$i]->tipo }}</td>
                           <td>Q. {{ number_format($pacientes[$i]->deuda - $pacientes[$i]->abono, 2) }}</td>
                           <td>
                              <a class="btn btn-sm btn-primary " href="{{ route('pacientes.show',$pacientes[$i]->id) }}"><i class="fa fa-fw fa-eye"></i> </a>
                           </td>
                           </tr>
                           @endfor
                     </tbody>
                  </table>
               </div>
            </div>
         </div>

      </div>
   </div>
</div>
@endsection



@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
   $(document).ready(function() {
      $('#table_id').DataTable({
         "language": {
            'info': '_TOTAL_ REGISTROS',
            'search': 'BUSCAR',
            'paginate': {
               'next': 'SIGUIENTE',
               'previous': 'ATRAS'
            },
            'loadingRecords': 'CARGANDO',
            'emptyTable': 'NO EXISTEN DATOS',
            'zeroRecords': 'NO EXISTEN DATOS IGUALES'
         }
      });
   });
</script>
@endsection