<div class="row">

    <div class="col-md-6">
        <div class="card card-info card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">PRESUPUESTO</div>
                <div class="card-desc">
                    IMPRIME EL PRESUPUESTO REALIZADO PARA EL PACIENTE.
                </div>
                <div class="card-detail">

                    <form action="{{ route('presup.pritPresupuesto', ['id' => $paciente->id]) }}" method="get">

                        @include('admin.pacientes.components.hojas')

                        <button type="submit" class="btn btn-info"><i class="fa fa-print"
                                aria-hidden="true"></i></button>

                    </form>


                </div>
            </div>
        </div>
    </div>




    <div class="col-md-6">
        <div class="card card-success card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">PROCEDIMIENTOS</div>
                <div class="card-desc">
                    ASIGNAMOS PAGOS A LOS DOCTORES, HISTORIAL DE PROCEDIMIENTO PARA PACIENTES.
                </div>
                <div class="card-detail">

                    <form action="{{ route('presup.procedimientosPrint', ['id' => $paciente->id]) }}" method="get">


                        @include('admin.pacientes.components.hojas')

                        <button type="submit" class="btn btn-info"><i class="fa fa-print"
                                aria-hidden="true"></i></button>
                    </form>



                </div>
            </div>
        </div>
    </div>

    @can('abono_store')
    <div class="col-md-6">

        <div class="card card-secondary card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">ABONOS</div>
                <div class="card-desc">
                    PERMITE HACER ABONOS E IMPRESIÓN DE RECIBO PARA LOS PACIENTES
                </div>
                <div class="card-detail">

                    <a target="_blank" class="btn btn-dark"
                        href="{{ route('abono.abonar', ['paciente' => $paciente->nombre, 'id' => $paciente->id]) }}"><i
                            class="fa fa-print" aria-hidden="true"></i></a>

                </div>
            </div>
        </div>


    </div>
    @endcan

    <div class="col-md-6">
        <div class="card card-primary card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">FICHA CLINICA</div>
                <div class="card-desc">
                    PERMITE IMPRIMIR LA FICHA CLINICA
                </div>
                <div class="card-detail">

                    <a target="_blank" class="btn btn-dark"
                        href="{{ route('pacientes.printFicha', ['paciente' => $paciente->nombre, 'id' => $paciente->id]) }}"><i
                            class="fa fa-print" aria-hidden="true"></i>
                    </a>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">

        <div class="card card-warning card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">RADIOGRAFIAS PACIENTE</div>
                <div class="card-desc">
                    PERMITE ASIGNAR RADIOGRAFÍAS AL PACIENTE
                </div>
                <div class="card-detail">

                    <a target="_blank" class="btn btn-dark"
                        href="{{ route('paciente.radiografia', ['id' => $paciente->id]) }}"><i class="fa fa-print"
                            aria-hidden="true"></i>
                    </a>

                </div>
            </div>
        </div>
    </div>



    <div class="col-md-6">

        <div class="card card-dark card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">LABORATORIO</div>
                <div class="card-desc">
                    PERMITE ASIGNAR UN PACIENTE A UN LABORATORIO PARA PAGOS FUTURO
                </div>
                <div class="card-detail">

                    <a target="_blank" class="btn btn-dark"
                        href="{{ route('paciente.paciente', ['id' => $paciente->id]) }}"><i class="fa fa-print"
                            aria-hidden="true"></i>
                    </a>

                </div>
            </div>
        </div>

    </div>

    <div class="col-md-6">

        <div class="card card-danger card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">DEUDA MEDICAMENTOS</div>
                <div class="card-desc">
                    PERMITE ASIGNAR UNA DEUDA POR UN MEDICAMENTO
                </div>
                <div class="card-detail">

                    <a target="_blank" class="btn btn-dark"
                        href="{{ route('deuda.deudaMedicamentos', ['id' => $paciente->id]) }}"><i class="fa fa-print"
                            aria-hidden="true"></i>
                    </a>

                </div>
            </div>
        </div>

    </div>

    <div class="col-md-6">

        <div class="card card-secondary card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">CARGAR FIRMA</div>
                <div class="card-desc">
                    PERMITE ASIGNAR LA FIRMA PARA POSTERIOR USO
                </div>
                <div class="card-detail">

                    <form action="{{ route('paciente.setFirma') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="paciente_id" value="{{ $paciente->id }}">
                        <input type="file" name="firma">
                        <button type="submit" class="btn btn-primary">GUARDAR</button>

                    </form>

                </div>
            </div>
        </div>

    </div>

    <div class="col-md-6">
        <div class="card card-primary card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">DIARIO</div>
                <div class="card-desc">
                    PERMITE VISUALIZAR LAS NOTAS DIARIAS DE UN PACIENTE
                </div>
                <div class="card-detail">
                    <a class="btn btn-dark" href="{{ route('diario.index', ['id' => $paciente->id]) }}"><i
                            class="fa fa-print" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card card-primary card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">DIARIO ORTODONCIA</div>
                <div class="card-desc">
                    PERMITE VISUALIZAR DIARIO DE ORTODONCIA DE UN PACIENTE
                </div>
                <div class="card-detail">
                    <a class="btn btn-dark" href="{{ route('diario.index', ['id' => $paciente->id, 'tipo' => 'ORTODONCIA']) }}"><i
                            class="fa fa-print" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card card-info card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">PERIODONTOGRAMA</div>
                <div class="card-desc">
                    PERMITE ASIGNAR EL DOCUMENTO PERIODONTOGRAMA
                </div>
                <div class="card-detail">
                    <a class="btn btn-dark" target="_blank"
                        href="{{ route('perio.index', ['id' => $paciente->id]) }}"><i class="fa fa-print"
                            aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card card-info card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">PRESUPUESTO PACIENTE</div>
                <div class="card-desc">
                    PERMITE IMPRIMIR EL PRESUPUESTO AGRUPADO POR TRATAMIENTO
                </div>
                <div class="card-detail">
                    <form action="{{ route('presup.agrupado', ['id' => $paciente->id]) }}" method="get">
                        @include('admin.pacientes.components.hojas')

                        <button type="submit" class="btn btn-info"><i class="fa fa-print"
                                aria-hidden="true"></i></button>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card card-info card-annoucement card-round">
            <div class="card-body text-center">
                <div class="card-opening">RECORDATORIO PACIENTE</div>
                <div class="card-desc">
                    PERMITE EL REGISTRO DE RECORDATORIO PARA EL PACIENTE
                </div>
                <div class="card-detail">
                    <a class="btn btn-dark" target="_blank"
                        href="{{ route('recopa.recordatorios', ['id' => $paciente->id]) }}"><i class="fa fa-print"
                            aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </div>

</div>