@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{asset('ventas/estilos.css')}}">
@endsection

@section('content')
<div class="container-fluid mt-4 p-2">
    <div class="row">

        <div class="container-fluid mt-4 p-2">
            @include('reports.pacientes.new_procedimiento.datos_descriptivos')

            <div class="row">
                @include('reports.pacientes.new_procedimiento.table')

                @include('reports.pacientes.new_procedimiento.tratamientos')



            </div>

            <button type="button" onclick="buscar('si')" class="btn  btn-sm btn-flotante2 mt-2">
                <i class="fa fa-search" aria-hidden="true"></i>
            </button>

            <button type="button" onclick="addToTable()" class="btn  btn-sm btn-flotante mt-2">
                <i class="fa fa-cart-plus" aria-hidden="true"></i>
            </button>

        </div>

    </div>
</div>
@endsection

@section('scripts')

<script>
    document.addEventListener('keyup', event => {
        // event.ctrlKey && , para nadir control
        // F8
        if (event.keyCode === 119) {
            document.getElementById("bt_submit").click();
        }
    }, false)




    var total = 0;
    var cont = 0;
    var subtotal = Array;
    const formulario = document.querySelector('#producto')
    const result = document.querySelector('#result')
    const preciog = document.querySelector('#preciog')
    const existenciag = document.querySelector('#existenciag')
    const cantidadg = document.querySelector('#cantidadg')
    const descuentog = document.querySelector('#descuentog')
    const id_producto = document.querySelector('#id_producto')
    const container = document.querySelector('#container')
    const totalg = document.querySelector('#total')
    const tabla_venta = $('#tabla_venta')
    const addDesc = document.querySelector('#addDesc');
    const cancela = document.querySelector('#cancela')
    const cambio = document.querySelector('#cambio')
    var nombreg = '';
    var descripciong = '';
    cantidadg.value = 1;
    var product = []
    var productG;

    function buscar(numero123) {
        let route = "{{ route('pac.getTratamientoAjax') }}"
        if (formulario.value.length >= 2) {
            if (event.keyCode === 13 || numero123 === 'si') {
                // Cancel the default action, if needed
                event.preventDefault();
                product = [];
                $.ajax({
                    type: "GET",
                    url: route,
                    data: {
                        codigo: formulario.value
                    },
                    dataType: "JSON",
                    success: function(resp) {
                        for (let i = 0; i < resp.length; i++) {
                            product.push({
                                id: parseInt(resp[i].id),
                                nombre: resp[i].nombre,
                                descripcion: resp[i].descripcion,
                                descripcion_interna: resp[i].descripcion_interna,
                                precio: resp[i].precio,
                                tipo: resp[i].tipo,
                                deleted_at: resp[i].deleted_at
                            })
                        }
                        result.innerHTML = '';
                        const texto = formulario.value.toLowerCase();
                        for (let data of product) {
                            let nombre = data.nombre;
                            let desc = data.descripcion;
                            let deleted_At = data.deleted_at;
                            if (nombre || desc) {

                                if (data.descripcion_interna) {
                                    result.innerHTML += `
                                        <div class="col-md-3 cursot-pointer mt-2" >
                                            <div class="card" onclick="add(${data.id})">
                                            <div class="card-body">
                                                <h6 class="card-title">${data.nombre}</h6>
                                                <p class="card-text">${data.descripcion}</p>
                                               <p>  Q. ${data.precio} </p>
                                                <p>TIPO: <b>${data.tipo} </p>
                                            </div>
                                        </div>

                                        <p class="text-center mt-1">
                                            <button class="btn btn-primary" type="button" data-toggle="collapse" data-target="#contentId${data.id}" aria-expanded="false" aria-controls="contentId">
                                            DESCRIPCION
                                            </button>
                                        </p>
                                        <div class="collapse" id="contentId${data.id}">
                                            ${data.descripcion_interna}
                                        </div>

                                        </div>`
                                } else {
                                    result.innerHTML += `
                                        <div class="col-md-3 cursot-pointer mt-2" >
                                            <div class="card" onclick="add(${data.id})">
                                                <div class="card-body">
                                                    <h6 class="card-title">${data.nombre}</h6>
                                                    <p class="card-text">${data.descripcion}</p>
                                                   <p>  Q. ${data.precio} </p>
                                                <p>TIPO: <b>${data.tipo} </p>
                                                </div>
                                            </div>
                                        </div>`
                                }
                                formulario.value = null;
                            }
                        }

                        if (result.innerHTML == '') {
                            result.innerHTML = '<li>SIN RESULTADOS</li>';
                            formulario.value = null;
                        }
                    }
                });
            }
        } else {
            produto = [];
        }
        return

    }

    formulario.addEventListener('keyup', buscar)

    document.addEventListener('keyup', event => {
        // event.ctrlKey && , para nadir control
        // clrl + b 
        if (event.keyCode === 190) {
            formulario.focus();
            buscar('si')
        }
    }, false)


    function add(idpro) {
        const {
            id,
            nombre,
            codigo,
            precio,
            stock,
            descripcion,
            minimo1,
            maximo1,
            precio1,
            minimo2,
            maximo2,
            precio2,
            minimo3,
            maximo3,
            precio3,
        } = product.find(e => e.id === idpro);

        productG = {
            id,
            nombre,
            codigo,
            precio,
            stock,
            descripcion,
            minimo1,
            maximo1,
            precio1,
            minimo2,
            maximo2,
            precio2,
            minimo3,
            maximo3,
            precio3,
        }
        let new_precio = prompt("Precio", precio);

        preciog.value = parseFloat(new_precio)
        id_producto.value = id
        nombreg = nombre;
        descripciong = descripcion;
        if (addDesc.value !== 'NORMAL') {
            let descuento = (preciog.value * addDesc.value) / 100;
            if (parseFloat(descuento) >= 0) {
                descuentog.value = parseFloat(descuento)
            } else {
                alert('NO SE APLICO EL DESCUENTO')
            }
        } else {
            addToTable();
        }
    }

    function limpiar() {
        preciog.value = '';
        existenciag.value = '';
        cantidadg.value = 1;
        descuentog.value = '';
        formulario.focus()
    }

    function eliminar_fila(index) {
        total = total - subtotal[index];
        totalg.innerHTML = ' <input type="number" id="totvent" name="totalventa" class="form-control d-none" style="height: 4vh;" value="' + total + '" readonly > <label>' + total.toFixed(2) + '</laberl';
        $('#fila' + index).remove();
    }


    function addToTable() {

        var newdescuento = 0;

        if (descuentog.value > 0) {
            newdescuento = (descuentog.value) * cantidadg.value;
        }

        if (id_producto.value != '' && preciog.value != '') {

            subtotal[cont] = (cantidadg.value * preciog.value) - newdescuento;
            total = total + subtotal[cont];

            var fila = '<tr class="selected" id="fila' + cont + '">' +
                '<td><a href="#" class="btn btn-danger btn-sm" onclick="eliminar_fila(' + cont + ')">X</a></td>' +
                '<td><input type="hidden" name="tratamiento_id[]" value="' + id_producto.value + '">' + nombreg + descripciong + '</td>' +
                '<td><input type="number" class="form-control d-none"  name="precioventa[]" value="' + preciog.value + '" readonly> <label> ' + preciog.value + '</label> </td> ' +
                '<td><input type="number" class="form-control d-none"  name="descuento[]" value="' + newdescuento + '" readonly > <label> ' + newdescuento + ' </label> </td> ' +
                '<td class="" ><input type="number" class="form-control d-none"  name="pieza[]" value="' + piezag.value + '" readonly >   <label> ' + piezag.value + ' </label> </td> ' +
                '<td> <input type="hidden" name="subtotal[]" value="' + subtotal[cont] + '">' + subtotal[cont] + '</td>' +
                '</tr>';
            cont++;
            limpiar();
            tabla_venta.prepend(fila);
            totalg.innerHTML = ' <input type="number" id="totvent" name="totalventa" class="form-control d-none" style="height: 4vh;" value="' + total + '" readonly > <label>' + total + '</laberl'

        } else {

            container.innerHTML += `
          <div class="alert alert-warning alert-dismissible fade show" role="alert">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  <span class="sr-only">Close</span>
              </button>
              <strong>SELECCIONE!</strong> UN PRODUCTO.
          </div>
      `
        }

    }


    function cambio_fun() {
        let cambiof = parseFloat(cancela.value)
        let newcambio = cambiof - total;
        cambio.innerHTML = '<label> CAMBIO: Q. ' + newcambio.toFixed(2) + '</label>';
    }
</script>

@endsection