<div class="col-md-3">
    <div class="card">
        <div class="float-right">
            <a class="btn btn-primary" href="{{ route('pacientes.index') }}"> <i class="fa fa-arrow-left"
                    aria-hidden="true"></i> Atras</a>
        </div>
        <div class="card-body">

            <div class="text-center">

                @if ($paciente->foto_perfil == null)
                <img width="150" src="https://ui-avatars.com/api/?name={{ $paciente->nombre }}"
                    class="img-fluid rounded-circle" alt="{{ config('app.name') }}" srcset="">
                @else
                <img width="150" src="{{ asset('storage/' . 'pacientes/fotos/' .$paciente->foto_perfil) }}"
                    class="img-fluid " alt="{{ config('app.name') }}" srcset="">

                @endif


                <h4 class="text-center">{{ $paciente->nombre }}</h4>
                <hr>
            </div>

            <div class="row">

                <div class="col-md-6">
                    No. de Ficha <br>
                    <span class="badge badge-warning" style="font-size: 14px;">No. {{ $paciente->id }}</span>
                </div>

                <div class="col-md-6">



                    <?php
                    $trabajado = $paciente->procedimientos->where('fecha', '!=', null)->sum('valor') ?? 0;
                    $totalabona = $paciente->abonoModel->sum('valor') ?? 0;
                    ?>
                    Total Trabajado:
                    <span class="badge badge-success" style="font-size: 14px;">
                        Q. {{ number_format($trabajado, 2) }}
                    </span>

                    <br>

                    Total Abonado:
                    <span class="badge badge-info" style="font-size: 14px;">
                        Q. {{ number_format($totalabona, 2) }}
                    </span>



                    <br>
                    <br>


                    Deuda:
                    @if ($totalabona < $trabajado)
                        <span class="badge badge-danger" style="font-size: 14px;">
                        <b>Q.{{ number_format($trabajado - $totalabona, 2) }}</b>
                        </span>
                        @elseif($totalabona > $trabajado)
                        <span class="badge badge-success" style="font-size: 14px;">
                            TIENE A FAVOR <br>
                            <b>
                                Q. {{ number_format($totalabona - $trabajado, 2) }}
                            </b>
                        </span>
                        @elseif ($totalabona === $trabajado)
                        <span class="badge badge-info" style="font-size: 14px;">
                            <b>
                                PAGOS AL DIA
                            </b>
                        </span>
                        @endif

                </div>
            </div>

            <div class="row mt-4">
                <div class="col-md-6">
                    Edad:
                    <br>
                    <span class="badge badge-primary" style="font-size: 14px;"> {{ $edad }} años</span>
                </div>

                <div class="col-md-6">
                    Tipo:
                    <br>
                    <span class="badge badge-dark" style="font-size: 14px;"> {{ $paciente->tipo }}</span>
                </div>
            </div>

            <a class="btn btn-warning mt-3" href="{{ route('pacientes.edit', $paciente->id) }}" role="button"> <i
                    class="fa fa-refresh" aria-hidden="true"></i> ACTUALIZAR</a>

        </div>

        <div class="card-body">

            <small class="text-muted pt-4 db">Motivo de Consulta </small>
            <h6>{{ $paciente->aut1 }}</h6>

            <small class="text-muted pt-4 db">Telefono </small>
            <h6>{{ $paciente->telefono }}</h6>
            <small class="text-muted pt-4 db">Direccion</small>
            <h6>{{ $paciente->direccion }}</h6>
            <small class="text-muted pt-4 db">Estado</small>
            @if ($paciente->estado === 'ACTIVO')
            <h6>Activo</h6>
            @else
            <h6>Inactivos</h6>
            @endif


            <small class="text-muted pt-4 db">Fecha de Registro</small>
            <h6>{{ $paciente->created_at }}</h6>


            <small class="text-muted pt-4 db">Ultmia de Actualizacion</small>
            <h6>{{ $paciente->updated_at }}</h6>

            <p>
                <a class="btn btn-primary btn-sm" data-toggle="collapse" href="#contentId" aria-expanded="false"
                    aria-controls="contentId">
                    Datos de Encargado
                </a>
            </p>
            <div class="collapse" id="contentId">
                <p><b>Nombre:</b> {{ $paciente->nombre_en }} </p>
                <p><b>Edad:</b> {{ $paciente->edad_en }} </p>
                <p><b>Direccion:</b> {{ $paciente->direccion_en }} </p>
                <p><b>Telefono:</b> {{ $paciente->telefono_en }} </p>
                <p><b>Relacion:</b> {{ $paciente->relacion_en }} </p>
            </div>

        </div>


    </div>
</div>