@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')

<div class="row">



   <div class="col-md-4">
      <div class="card">
         <div class="card-header">
            Pacientes Ortodoncia
         </div>
         <div class="card-body text-center">
            <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/patient.png')}}" alt="{{config('app.name')}}">


            <p class="card-text">IMPRIME REPORTE DE LOS PACIENTES EN ORTODONCIA</p>
         </div>
         <div class="card-footer text-muted">
            <form action="{{route('orto.paciente_orto_fecha')}}" method="POST">
               @csrf
               <div class="form-group">
                  <label for="">Fecha De Inicio</label>
                  <input type="date" name="inicio" class="form-control datepicker">
               </div>
               <div class="form-group">
                  <label for="">Fecha Final</label>
                  <input type="date" name="final" class="form-control datepicker">
               </div>
               <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>
            </form>

         </div>
      </div>
   </div>

   <div class="col-md-4">
      <div class="card">
         <div class="card-header">
            Doctores Ortodoncia
         </div>
         <div class="card-body text-center">
            <img class="img-fluid" style="width: 60%" src="{{asset('assets/images/doctor.png')}}" alt="{{config('app.name')}}">

            <p class="card-text">IMPRIME REPORTE DE PAGOS A DOCTORES DE ORTODONCIA FILTRADOS POR FECHA</p>
         </div>
         <div class="card-footer text-muted">
            <form action="{{route('orto.paciente_orto_fecha')}}" method="POST">
               @csrf

               <div>
                  <label for="">DOCTOR</label>
                  <select class="form-control" name="doctor_id" id="doctor_id" required>
                     @foreach ($doc as $d)
                     <option value="{{$d->id}}">{{$d->nombre}}</option>
                     @endforeach
                  </select>
               </div>

               <div class="form-group">
                  <label for="">Fecha De Inicio</label>
                  <input type="date" name="inicio" class="form-control datepicker">
               </div>
               <div class="form-group">
                  <label for="">Fecha Final</label>
                  <input type="date" name="final" class="form-control datepicker">
               </div>
               <button type="submit" class="btn btn-success"><i class="fa fa-search" aria-hidden="true"></i> BUSCAR</button>
            </form>

         </div>
      </div>
   </div>
</div>
@endsection


@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}">
</script>

<script>
   setTimeout(function() {
      new SlimSelect({
         select: '#doctor_id',
         placeholder: 'SELECCIONE MULTIPLES RECETAS PARA SU PACIENTE',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300);
</script>
@endsection