@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/slim-select/slimselect.min.css') }}">
@endsection

@section('content')
<div class="row justify-content-center">
   <div class="col-md-3">
      ORTODONCIA
   </div>
   <div class="col-md-3">
      <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#modelId">
         NUEVO REGISTRO
      </button>
   </div>
   <div class="col-md-3">
      <!-- Button trigger modal -->
      <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#descuento">
         DESCUENTO
      </button>
   </div>
</div>

<div class="row">
   <div class="col card p-4 table-responsive">
   <div class="h3 text-center">PACIENTES OPERADOS</div>

      <table class="table">
         <thead>
            <tr>
               <th>PACIENTE</th>
               <th>DOCTOR</th>
               <th>G. DOCTOR</th>
               <th>CLÍNICA</th>
               <th>OTROS</th>
               <th>TOTAL</th>
               <th></th>

            </tr>
         </thead>
         <tbody>
            <?php $t = 0;
            $t2 = 0;
            $t3 = 0; ?>

            @foreach ($orto as $o)

            <?php
            $t += $o->g_doc;
            $t2 += $o->g_cli;
            $t3 += $o->total;
            ?>
            <tr>
               <td>{{$o->paciente}} </td>
               <td>{{$o->doctor->nombre}}</td>
               <td>Q. {{number_format($o->g_doc, 2)}}</td>
               <td>Q. {{number_format($o->g_cli, 2)}}</td>
               <td>{{$o->descripcion}}</td>
               <td>Q. {{number_format($o->total, 2)}}</td>
               <td>
                  <form action="{{route('orto.delete', $o->id)}}" method="post">
                     @csrf
                     @method('DELETE')

                     <a class="btn btn-primary" href="{{route('orto.print_reciboo', $o->id)}}" role="button"><i class="fa fa-print" aria-hidden="true"></i></a>

                     <button type="submit" class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></button>
                  </form>
               </td>
            </tr>
            @endforeach

         </tbody>
      </table>


      <div class="row">
         <div class="col">
            <div class="table-responsive">
               <div class="h3 text-center">DESCUENTOS DE PAGO</div>
               <table class="table">
                  <thead>
                     <tr>
                        <th>#</th>
                        <th>DESCRIPCIÓN</th>
                        <th>VALOR</th>
                        <th></th>

                     </tr>
                  </thead>
                  <tbody>
                     <?php $td=0; ?>
                     @foreach ($salida as $S)
                     <?php $td += $S->valor;?>
                     <tr>
                        <td>{{$S->id}}</td>
                        <td>{{$S->descripcion}}</td>
                        <td>Q. {{number_format($S->valor, 2)}}</td>
                        <td>
                           <a onclick="return confirm('Esta Seguro de Eliminar?')" class="btn btn-danger" href="" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                        </td>
                     </tr>
                     @endforeach
                  </tbody>
               </table>
            </div>
         </div>
      </div>


      <h5>DOCTOR: Q. {{number_format($t, 2)}} </h5>
      <h5>CLÍNICA: Q. {{number_format($t2, 2)}}</h5>

      <h5>TOTAL EN DESCUENTOS: Q.{{number_format($td, 2)}}</h5>

      <h5>TOTAL: Q. {{number_format($t3 - $td, 2)}} </h5>
   </div>

</div>



<!-- Modal -->
<div class="modal fade" id="descuento" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
   <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title">DESCUENTO DE PAGO</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <div class="modal-body">
            <form action="{{route('orto.decuento_Orto')}}" method="post">
               @csrf
               <input type="hidden" name="tipo" value="ORT">
               <div class="form-group">
                  <label for="descripcion">DESCRIPCIÓN</label>
                  <textarea class="form-control" name="descripcion" id="descripcion" rows="3"></textarea>
               </div>

               <div class="form-group">
                  <label for="valor">VALOR</label>
                  <input type="number" step="any" class="form-control" name="valor">
               </div>

               <button type="submit" class="btn btn-primary float-right"><i class="fas fa-save    "></i> GUARDAR</button>
            </form>
         </div>
      </div>
   </div>
</div>




<!-- Modal -->
<div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
   <div class="modal-dialog" role="document">
      <div class="modal-content">
         <div class="modal-header">
            <h5 class="modal-title">REGISTRO DE ORTODONCIA</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
         </div>
         <form action="{{route('orto.store')}}" method="post">
            @csrf
            <div class="modal-body">

               <div class="form-group">
                  <label for="">PACIENTE</label>
                  <input type="text" class="form-control" name="paciente" id="" aria-describedby="helpId" placeholder="">
               </div>

               <div>
                  <label for="">DOCTOR</label>
                  <select class="form-control" name="doctor_id" id="doctor_id" required>
                     @foreach ($doc as $d)
                     <option value="{{$d->id}}">{{$d->nombre}}</option>
                     @endforeach
                  </select>
               </div>

               <div class="form-group">
                  <label for="">G. DOCTOR</label>
                  <input type="number" step="any" class="form-control" name="g_doc">
               </div>

               <div class="form-group">
                  <label for="">CLÍNICA</label>
                  <input type="number" step="any" class="form-control" name="g_cli">
               </div>

               <div class="form-group">
                 <label for="descripcion">OTROS</label>
                 <textarea class="form-control" name="descripcion"  rows="3"></textarea>
               </div>

               <div class="form-group">
                  <label for="">TOTAL</label>
                  <input type="number" step="any" class="form-control" name="total">
               </div>

            </div>
            <div class="modal-footer">
               <button type="button" class="btn btn-secondary" data-dismiss="modal">CERRAR</button>
               <button type="submit" class="btn btn-primary">GUARDAR</button>
            </div>
         </form>
      </div>
   </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/slim-select/slimselect.min.js') }}"></script>

<script>
   setTimeout(function() {
      new SlimSelect({
         select: '#paciente_id',
         placeholder: 'SELECCIONE MULTIPLES RECETAS PARA SU PACIENTE',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300);

   setTimeout(function() {
      new SlimSelect({
         select: '#doctor_id',
         placeholder: 'SELECCIONE SU PACIENTE',
         deselectLabel: '<span>&times;</span>',
         hideSelectedOption: true,
      })
   }, 300);
</script>
@endsection
