@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">
            <div class="card mb-5">

                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <p style="font-size: 172%">
                            Mobiliario y Equipo
                        </p>

                        <div class="float-right">
                            <a href="{{ route('mobiliario-y-equipo.create') }}" class="btn btn-primary  float-right" data-placement="left">
                                {{ __('Registrar Nuevo Mobiliario y Equipo') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>CANTIDAD </th>
                                <th>DESCRIPCIÓN</th>
                                <th>PRECIO</th>
                                <th>FECHA DE MANTENIMIENTO</th>
                                <th>FECHA DE REGISTRO</th>
                                <th>FECHA DE MODIFICACIÓN</th>
                                <th>ACCIÓN</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($mobiliarios as $mobi)
                            <tr>
                                <td class="text-uppercase">{{$mobi->mobiliario}}</td>
                                <td>{{$mobi->cantidad}}</td>
                                <td class="text-uppercase">{{$mobi->descripcion}}</td>
                                <td>Q. {{number_format($mobi->precio, 2)}}</td>
                                <td>{{$mobi->fecha_mantenimiento}}</td>
                                <td>{{$mobi->created_at}}</td>
                                <td>{{$mobi->updated_at}}</td>

                                <td>

                                    @can('mobiliario_update')
                                    <a class="btn btn-sm btn-primary" href="{{route('mobiliario-y-equipo.show', $mobi->id)}}"><i class="fa fa-eye" aria-hidden="true"></i> </a>
                                    @endcan

                                    @can('mobiliario_delete')
                                    <form action="{{route('mobiliario-y-equipo.destroy', $mobi->id)}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-sm btn-danger" type="submit" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </button>
                                    </form>
                                    @endcan

                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>




                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'BUSCAR',
                'paginate': {
                    'next': 'SIGUIENTE',
                    'previous': 'ATRAS'
                },
                'loadingRecords': 'CARGANDO',
                'emptyTable': 'NO HAY DATOS',
                'zeroRecords': 'NO HAY DATOS IGUALES'
            }
        });
    });
</script>
@endsection