@extends('layouts.admin')

@section('content')
<div class="container-fluid">
   <div class="row">
      <div class="col-md-4">
         <div class="card">
            <div class="card-body">
               <h4 class="card-title">{{$laboratorio->nombre}}</h4>
               <p class="card-text">{{$laboratorio->direccion}}</p>
               <p class="card-text">{{$laboratorio->telefono}}</p>
            </div>

            <!-- Button trigger modal -->
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modelId">
               NUEVO SERVICIO
            </button>

            <!-- Modal -->
            <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
               <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                     <div class="modal-header">
                        <h5 class="modal-title">NUEVO SERVICIO</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                           <span aria-hidden="true">&times;</span>
                        </button>
                     </div>

                     <form action="{{route('lab.storeServicio')}}" method="post">
                        @csrf
                        <input type="hidden" name="laboratorio_id" value="{{$laboratorio->id}}">
                        <div class="modal-body">

                           <div class="form-group">
                              <label for="nombre">SERVICIO</label>
                              <input type="text" class="form-control text-uppercase" name="nombre" placeholder="NOMBRE DE SERVICIO" required>
                           </div>

                           <div class="form-group">
                              <label for="precio">COSTO DE SERVICIO</label>
                              <input type="number" step="any" class="form-control" name="precio" placeholder="COSTO DEL SERVICIO" required>
                           </div>



                        </div>
                        <div class="modal-footer">
                           <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                           <button type="submit" class="btn btn-primary">GUARDAR</button>
                        </div>
                     </form>
                  </div>
               </div>
            </div>

         </div>
      </div>

      <div class="col-md-8">
         <div class="card">
            <div class="card-body">
               <h4 class="card-title">SERVICIOS PRESTADOS</h4>
               <div class="table-responsive">
                  <table class="table">
                     <thead>
                        <tr>
                           <th>Servicio</th>
                           <th>Costo</th>
                           <th></th>
                        </tr>
                     </thead>
                     <tbody>
                        @foreach ($servicios as $serv)
                        <tr>
                           <td>{{$serv->nombre}}</td>
                           <td>Q. {{number_format($serv->precio, 2)}}</td>
                           <td>
                              <form action="{{route('lab.deleteService', ['id' => $serv->id])}}" method="post">
                                 @csrf
                                 @method('DELETE')
                                 <button type="submit" class="btn btn-danger " onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i></button>
                              </form>
                           </td>
                        </tr>
                        @endforeach
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>

   </div>
</div>
@endsection