@extends('layouts.admin')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">LABORATORIOS</h4>
                    <p class="card-text">PERMITE GENERAR EL REPORTE DE TODOS LOS LABORATORIOS</p>
                    <a href="{{route('lab.reporteAll')}}" target="_blank" class="btn btn-dark" href="#" role="button"><i class="fa fa-print" aria-hidden="true"></i>IMPRIMIR</a>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">DEUDAS DEL MES</h4>


                    <form action="{{route('lab.pacienteLaboratorio')}}" method="post">
                        @csrf

                        <div class="form-group">
                            <label for="laboratorio_id">LABORATORIO</label>
                            <select class="form-control" name="laboratorio_id" id="laboratorio_id">
                                @foreach ($laboratorios as $lab)
                                <option value="{{$lab->id}}">{{$lab->nombre}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="mes">Año</label>
                            <select class="form-control" name="ano">
                                @for($i = 2021; $i < 2051; $i ++) <option value="{{$i}}">Año: {{$i}}</option>
                                    @endfor
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="mes">Mes</label>
                            <select class="form-control" name="mes">
                                <option selected hidden>Mes</option>
                                <option value="01">Enero</option>
                                <option value="02">Febrero</option>
                                <option value="03">Marzo</option>
                                <option value="04">Abril</option>
                                <option value="05">Mayo</option>
                                <option value="06">Junio</option>
                                <option value="07">Julio</option>
                                <option value="08">Agosto</option>
                                <option value="09">Septiembre</option>
                                <option value="10">Octubre</option>
                                <option value="11">Noviembre</option>
                                <option value="12">Diciembre</option>
                            </select>
                        </div>


                        <button type="submit" class="btn btn-dark"><i class="fa fa-print" aria-hidden="true"></i>IMPRIMIR</button>
                    </form>

                    <p class="card-text">PERMITE GENERAR EL REPORTE DE "DEUDAS" A LOS LABORATORIOS""</p>

                </div>
            </div>
        </div>



        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">CONSUMIDO DE LABORATORIO</h4>
                    <p class="card-text">PERMITE GENERAR EL REPORTE DE TODAS LO CONSUMIDO EN LOS LABORATORIOS</p>


                    <form action="{{route('lab.deudaLaboratorio')}}" method="get">

                        <div class="form-group">
                            <label for="mes">Mes</label>
                            <select class="form-control" id="mes" name="mes">
                                <option value="01">Enero</option>
                                <option value="02">Febrero</option>
                                <option value="03">Marzo</option>
                                <option value="04">Abril</option>
                                <option value="05">Mayo</option>
                                <option value="06">Junio</option>
                                <option value="07">Julio</option>
                                <option value="08">Agosto</option>
                                <option value="09">Septiembre</option>
                                <option value="10">Octubre</option>
                                <option value="11">Noviembre</option>
                                <option value="12">Diciembre</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="anio">Año</label>
                            <select class="form-control" id="anio" name="anio">
                                @for ($year = 2023; $year <= 2045; $year++)
                                    <option value="{{ $year }}">{{ $year }}</option>
                                    @endfor
                            </select>
                        </div>

                        <button type="submit" class="btn btn-primary"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </form>



                </div>
            </div>
        </div>

    </div>
</div>

@endsection