@extends('layouts.admin')

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">
            <div class="card">
                <div class="card-header">
                    LABORATORIOS
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table ">
                            <thead class="thead-inverse">
                                <tr>
                                    <th>NOMBRE</th>
                                    <th>DIRECCIÓN</th>
                                    <th>TELÉFONO</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($laboratorios as $laboratorio)
                                <tr>
                                    <td>{{$laboratorio->nombre}}</td>
                                    <td>{{$laboratorio->direccion}}</td>
                                    <td>{{$laboratorio->telefono}}</td>
                                    <td>

                                        <a class="btn btn-primary" href="{{route('lab.show', ['id' => $laboratorio->id])}}" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>

                                        <form action="{{route('lab.delete', ['id' => $laboratorio->id])}}" method="post">
                                            @CSRF
                                            @method('DELETE')
                                            <button type="submit" onclick="return confirm('¿Estas Seguro de Eliminar?')" class="btn btn-danger"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>

                        {{$laboratorios->links()}}
                    </div>


                </div>
            </div>

        </div>
    </div>
</div>

@endsection