@extends('layouts.admin')

@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col">
            <div class="card p-4 mb-5">
                <h4 class="card-title text-uppercase">{{$insumo->nombre}} </h4>

                <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">

                    <li class="nav-item">
                        <a class="nav-link active text-capitalize" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">datos de insumo</a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">Actualizar</a>
                    </li>


                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active text-center" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">

                        <h4> Insumo / {{$insumo->nombre}}</h4>

                        <div class="card p-3">
                            <div class="center">
                            </div>
                            <div class="card-body">
                                <h5 class="card-title text-uppercase">Nombre:{{$insumo->nombre}}</h5>
                                <p class="card-text text-capitalize">Precio: {{$insumo->precio}}</p>
                                <p class="card-text text-capitalize">Cantidad: {{$insumo->lotes->sum('cantidad')}}</p>
                                <p class="card-text text-capitalize">Factura: {{$insumo->factura}}</p>
                                <p class="card-text text-capitalize">Fecha Vencimiento: {{$insumo->fecha_vencimiento}}</p>
                                <p class="card-text text-capitalize">Notificar Mínimo: {{$insumo->minio}}</p>
                                <p class="card-text text-capitalize">Fecha de Actualización: {{$insumo->updated_at}}</p>

                            </div>
                        </div>




                    </div>
                    <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                        <h4>Actualizar Categoría</h4>


                        <form action="{{route('insumos.update',  $insumo)}}" method="POST">
                            @CSRF
                            @method('PUT')

                            <div class="form-group">
                                <label for="nombre">Nombre del Insumo</label>
                                <input type="text" name="nombre" id="nombre" class="form-control" value="{{ $insumo->nombre }}" required>
                            </div>

                            <div class="form-group">
                                <label for="precio">Precio</label>
                                <input type="number" name="precio" id="precio" class="form-control" step="0.01" value="{{ $insumo->precio }}">
                            </div>

                            <div class="form-group">
                                <label for="minimo">Stock Mínimo</label>
                                <input type="number" name="minimo" id="minimo" class="form-control" value="{{ $insumo->minimo }}">
                            </div>

                            <h2>Lotes de Insumos</h2>

                            <table class="table" id="lotes-table">
                                <thead>
                                    <tr>
                                        <th>Cantidad</th>
                                        <th>Fecha de Vencimiento</th>
                                        <th>Factura</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($insumo->lotes as $lote)
                                    <tr id="lote-row-{{ $lote->id }}">
                                        <td><input type="hidden" name="lotes[{{ $loop->index }}][id]" value="{{ $lote->id }}">
                                            <input type="number" class="form-control" name="lotes[{{ $loop->index }}][cantidad]" value="{{ $lote->cantidad }}" required>
                                        </td>
                                        <td><input type="date" class="form-control" name="lotes[{{ $loop->index }}][fecha_vencimiento]" value="{{ $lote->fecha_vencimiento }}"></td>
                                        <td><input type="text" class="form-control" name="lotes[{{ $loop->index }}][factura]" value="{{ $lote->factura }}"></td>

                                        <td>
                                            <button type="button"
                                                class="btn btn-danger btn-sm delete-lote-ajax"
                                                data-id="{{ $lote->id }}"
                                                data-url="{{ route('insumos.loteDestroy', $lote) }}">
                                                <i class="fa fa-trash" aria-hidden="true"></i> Eliminar
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            <button type="button" id="agregar-lote" class="btn btn-primary">Agregar Lote</button>



                            <button type="submit" class="btn btn-success btn-block"> <i class="fa fa-save"></i> Actualizar</button>
                        </form>


                    </div>

                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const agregarLoteBtn = document.getElementById('agregar-lote');
        const lotesTableBody = document.getElementById('lotes-table').querySelector('tbody');
        let loteCounter = <?php echo count($insumo->lotes) ?>; // Inicializar con el número de lotes existentes

        agregarLoteBtn.addEventListener('click', function() {
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
                <td><input type="number" class="form-control" name="lotes[${loteCounter}][cantidad]" required></td>
                <td><input type="date" class="form-control" name="lotes[${loteCounter}][fecha_vencimiento]"></td>
                <td><input type="text" class="form-control" name="lotes[${loteCounter}][factura]"></td>
                <td><button type="button" class="btn btn-danger btn-sm eliminar-lote">Eliminar</button></td>
            `;
            lotesTableBody.appendChild(newRow);
            loteCounter++;

            const eliminarLoteBtn = newRow.querySelector('.eliminar-lote');
            eliminarLoteBtn.addEventListener('click', function() {
                newRow.remove();
            });
        });


        // Lógica de eliminación con AJAX para lotes existentes
        document.querySelectorAll('.delete-lote-ajax').forEach(button => {
            button.addEventListener('click', function() {
                const loteId = this.getAttribute('data-id');
                const deleteUrl = this.getAttribute('data-url');

                if (!confirm('¿Estás seguro de eliminar este lote de forma permanente?')) {
                    return;
                }

                // 1. Construir la solicitud
                fetch(deleteUrl, {
                        method: 'DELETE',
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => {
                        // Si la respuesta es OK (200) o un error de cliente/servidor (4xx/5xx)
                        return response.json().then(data => ({
                            status: response.status,
                            body: data
                        }));
                    })
                    .then(({
                        status,
                        body
                    }) => {
                        if (status === 200) {
                            // 1. Éxito: Buscar y Eliminar la fila del DOM
                            // Esto ahora funcionará porque la fila tiene el ID 'lote-row-X'
                            const row = document.getElementById('lote-row-' + loteId);
                            if (row) {
                                row.remove();
                            }

                            // Opcional: Mostrar mensaje de éxito (usando una función flash de Laravel o SweetAlert)
                            alert(body.message);
                        } else if (status === 403) {
                            // 3. Fallo: El lote tiene salidas asociadas
                            alert('Error: ' + body.message);
                        } else {
                            // 4. Otros errores
                            alert('Error desconocido al eliminar el lote.');
                        }
                    })
                    .catch(error => {
                        console.error('Error en la solicitud AJAX:', error);
                        alert('Error de conexión o del servidor.');
                    });
            });
        });




    });
</script>
@endsection
