@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{asset('ventas/estilos.css')}}">]

@endsection

@section('content')
<div class="container-fluid mt-4 p-2">
    <div class="row">
        <div class="container-fluid mt-4 p-2">
            <div class="row d-none">
                <div class="col-md-6">
                    <h3 class="h5 text-center text-uppercase">Datos Descriptivos</h3>
                    <div class="form-group row mx-3">
                        <div class="row justify-content-center">
                            <input type="hidden" id="id_producto">
                            <input type="hidden" id="id_lote">
                            <div class="col-md-5">
                                Existencia
                                <input type="text" class="form-control" placeholder="Existencia" disabled id="cantidadg">
                            </div>
                        </div>
                        <button type="button" onclick="addToTable()" class="btn btn-bark btn-sm btn-block mt-2">ADD</button>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4">
                    <form action="{{route('si.salidaInsutmoStore')}}" method="post" autocomplete="off">
                        @csrf
                        <input type="hidden" name="paciente_id" value="{{$paciente_id}}">
                        <input type="hidden" name="procedamiento_id" value="{{$tratamiento_id}}">
                        <div class="card scrolling-wrapper-table">
                            <div class="table-hover p-2">
                                <table class="table table-hover table-sm " id="tabla_venta">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>INSUMO</th>
                                            <th>Vencimiento</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr></tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-info btn-block" id="bt_submit" onclick="return confirm('¿ESTA SEGURO DE CONTINUAR?')">REGISTRAR</button>
                    </form>
                </div>

                <div class="col-md-7">
                    <div class="row">
                        <div class="col-md-5">
                            <input type="text" id="producto" style="height: 4vh;" class="form-control" placeholder="INSUMO A BUSCAR">
                        </div>
                    </div>

                    <div class="row scrolling-wrapper overflow-auto" id="result"></div>
                </div>
            </div>

            <button type="button" onclick="buscar('si')" class="btn  btn-sm btn-flotante2 mt-2">
                <i class="fa fa-search" aria-hidden="true"></i>
            </button>

            <button type="button" onclick="addToTable()" class="btn  btn-sm btn-flotante mt-2">
                <i class="fa fa-cart-plus" aria-hidden="true"></i>
            </button>
        </div>
    </div>
</div>
@endsection
@section('scripts')

<script>
    document.addEventListener('keyup', event => {
        // event.ctrlKey && , para nadir control
        // F8
        if (event.keyCode === 119) {
            document.getElementById("bt_submit").click();
        }
    }, false)




    var total = 0;
    var cont = 0;
    var subtotal = Array;
    const formulario = document.querySelector('#producto')
    const result = document.querySelector('#result')
    const preciog = document.querySelector('#preciog')
    const cantidadg = document.querySelector('#cantidadg')
    const descuentog = document.querySelector('#descuentog')
    const id_producto = document.querySelector('#id_producto')
    const container = document.querySelector('#container')
    const totalg = document.querySelector('#total')
    const tabla_venta = $('#tabla_venta')
    const addDesc = document.querySelector('#addDesc');
    const cancela = document.querySelector('#cancela')
    const cambio = document.querySelector('#cambio')
    var nombreg = '';
    var descripciong = '';
    cantidadg.value = 1;
    var product = []
    var productG;

    function buscar(numero123) {
        let route = "{{ route('si.searchAjax') }}"
        if (formulario.value.length >= 2) {
            if (event.keyCode === 13 || numero123 === 'si') {
                event.preventDefault();
                product = [];
                $.ajax({
                    type: "GET",
                    url: route,
                    data: {
                        codigo: formulario.value
                    },
                    dataType: "JSON",
                    success: function(resp) {
                        result.innerHTML = '';
                        for (let insumo of resp) {
                            for (let lote of insumo.lotes) {
                                if (lote.cantidad > 0) {
                                    result.innerHTML += `
                                    <div class="col-md-3 cursot-pointer mt-2" >
                                        <div class="card" onclick="add(${insumo.id}, ${lote.id})" \>
                                            <div class="card-body">
                                            <h6 class="card-title"></span>${insumo.nombre}</h6>
                                            <p class="card-text"> LOTE: ${lote.fecha_vencimiento} - STOCK: ${lote.cantidad}</p>
                                            </div>
                                        </div>
                                    </div>`;
                                }
                            }
                        }

                        if (result.innerHTML == '') {
                            result.innerHTML = '<li>SIN RESULTADOS</li>';
                            formulario.value = null;
                        }
                    }
                });
                formulario.value = '';
            }
        } else {
            produto = [];
        }
        return
    }


    formulario.addEventListener('keyup', buscar)

    document.addEventListener('keyup', event => {
        // event.ctrlKey && , para nadir control
        // clrl + b
        if (event.keyCode === 190) {
            formulario.focus();
            buscar('si')
        }
    }, false)


    function add(idInsumo, idLote) {
        $.ajax({
            type: "GET",
            url: "{{ route('si.getLoteData') }}",
            data: {
                insumo_id: idInsumo,
                lote_id: idLote
            },
            dataType: "JSON",
            success: function(data) {
                id_producto.value = idInsumo;
                id_lote.value = idLote;
                cantidadg.value = data.cantidad;
                nombreg = data.nombre;
                addToTable();
            }
        });
    }

    function limpiar() {
        preciog.value = '';
        cantidadg.value = '';
        cantidadg.value = 1;
        descuentog.value = '';
        formulario.focus()
    }

    function eliminar_fila(index) {
        total = total - subtotal[index];
        $('#fila' + index).remove();
    }


    function addToTable() {

        if (id_producto.value != '' && nombreg.value != '') {
            $.ajax({
                type: "GET",
                url: "{{ route('si.getLoteData') }}",
                data: {
                    insumo_id: id_producto.value,
                    lote_id: id_lote.value
                },
                dataType: "JSON",
                success: function(data) {
                    var fila = '<tr class="selected" id="fila' + cont + '">' +
                        '<td><a href="#" class="btn btn-danger btn-sm" onclick="eliminar_fila(' + cont + ')">X</a></td>' +
                        '<td><input type="hidden" name="insumo_id[]" value="' + id_producto.value + '">' +
                        '<input type="hidden" name="lote_id[]" value="' + id_lote.value + '">' + nombreg + '</td>' +
                        '<td>' + data.fecha_vencimiento + '</td>' +
                        '</tr>';
                    tabla_venta.prepend(fila);
                    limpiar();
                }
            });
        } else {

            container.innerHTML += `
          <div class="alert alert-warning alert-dismissible fade show" role="alert">
              <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                  <span class="sr-only">Close</span>
              </button>
              <strong>SELECCIONE!</strong> UN PRODUCTO.
          </div>
      `
        }

    }


    function cambio_fun() {
        let cambiof = parseFloat(cancela.value)
        let newcambio = cambiof - total;
        cambio.innerHTML = '<label> CAMBIO: Q. ' + newcambio.toFixed(2) + '</label>';
    }
</script>

@endsection