@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('assets/theme/vendor/select2/select2.min.css')}}">
@endsection

@section('content')

<div class="container-fluid">
   <div class="row">
      <div class="col">
         <div class="card mb-5">
            <div class="card-header">
               <p style="font-size: 172%">
                  SALIDAS INSUMOS
               </p>
               <div class="float-right">
                  @can('insumo_salidaStore')
                  <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modelId">
                     REGISTRAR SALIDA DE INSUMO
                  </button>
                  @endcan
               </div>
            </div>
            @can('insumo_salidaStore')
            <!-- Modal -->
            <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
               <div class="modal-dialog" role="document">
                  <div class="modal-content">
                     <div class="modal-header">
                        <h5 class="modal-title">SALIDA DE INSUMO</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                           <span aria-hidden="true">&times;</span>
                        </button>
                     </div>
                     <form action="{{route('insumos.salidaStore')}}" method="post">
                        @csrf
                        <div class="modal-body">

                           <input type="hidden" name="user_id" value="{{Auth::user()->id}}">

                           <div class="form-group">
                              <label for="">INSUMO</label>
                              <select class="custom-select" name="insumo_id">
                                 @foreach ($insumos as $insumo )
                                 <option value="{{$insumo->id}}">{{$insumo->nombre}}/ CANTIDAD: {{$insumo->cantidad}}</option>
                                 @endforeach
                              </select>
                           </div>

                           <div class="form-group">
                              <label for="">CANTIDAD DE SALIDA</label>
                              <input type="number" class="form-control" name="cantidad" placeholder="CANTIDAD DE SALIDA" required>
                           </div>

                           <div class="form-group">
                              <label for="">UNIDAD</label>
                              <input type="number" class="form-control" name="clinica" placeholder="UNIDAD EN LA QUE SE UTILIZARA" required>
                           </div>

                        </div>
                        <div class="modal-footer">
                           <button type="button" class="btn btn-secondary" data-dismiss="modal">CANCELAR</button>
                           <button type="submit" class="btn btn-success">GUARDAR</button>
                        </div>
                     </form>
                  </div>
               </div>
            </div>
            @endcan

            @can('insumo_salidas')
            <div class="card-body table-responsive">
               <table class="table table-hover">
                  <thead>
                     <tr>
                        <th>INSUMO</th>
                        <th>CANTIDAD </th>
                        <th>UNIDAD </th>
                        <th>USUARIO </th>
                        <th>FECHA DE SALIDA </th>
                        <th>ACCION </th>
                     </tr>
                  </thead>
                  <tbody>
                     @foreach($salidas as $salida)
                     <tr>
                        <td>{{$salida->insumo}}</td>
                        <td>{{$salida->cantidad}}</td>
                        <td>{{$salida->clinica}}</td>
                        <td>{{$salida->name}}</td>
                        <td>{{$salida->created_at}}</td>
                        <td>
                           @can('insumo_salidaDelete')
                           <form action="{{route('insumos.deleteSalida')}}" method="post">
                              @csrf
                              @method('DELETE')

                              <input type="hidden" name="id" value="{{$salida->id}}">
                              <input type="hidden" name="insumo_id" value="{{$salida->insumo_id}}">
                              <input type="hidden" name="cantidad" value="{{$salida->cantidad}}">
                              <button type="submit" class="btn btn-sm btn-danger" href="" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </button>
                           </form>
                           @endcan

                        </td>
                     </tr>
                     @endforeach
                  </tbody>
               </table>
               {{$salidas->links()}}
            </div>
            @endcan

         </div>
      </div>
   </div>
</div>

@endsection


@section('scripts')
<script src="{{asset('assets/theme/vendor/select2/select2.min.js')}}"></script>
<script>
   $(document).ready(function() {
      $('#insumos').select2({
         width: '100% !important'
      });
   });
</script>
@endsection