@extends('layouts.admin')

@section('styles')
<link rel="stylesheet" href="{{asset('plugins/datatable/css/dataTables.bootstrap4.min.css')}}">
@endsection



@section('content')
<div class="container-fluid mb-5">
    <div class="row">
        <div class="col mb-5">
            <div class="card mb-5">

                <div class="card-header">
                    <div style="display: flex; justify-content: space-between; align-items: center;">

                        <p style="font-size: 172%">
                            INSUMOS
                        </p>

                        <div class="float-right">
                            <a href="{{ route('insumos.create') }}" class="btn btn-primary  float-right" data-placement="left">
                                {{ __('Registrar Nuevo Insumo') }}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body table-responsive">
                    <table class="table table-hover" id="table_id" data-page-length="15">
                        <thead>
                            <tr>
                                <th>Nombre</th>
                                <th>Precio </th>
                                <th>Cantidad </th>
                                <th>Mínimo </th>
                                <th>Factura </th>
                                <th>Fecha Vencimiento </th>
                                <th>Acción </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($insumos as $insumo)
                            <tr>
                                <td>{{$insumo->nombre}}</td>
                                <td>Q. {{number_format($insumo->precio, 2)}}</td>
                                <td>{{$insumo->lotes->sum('cantidad')}}</td>
                                <td>{{$insumo->minimo}}</td>
                                <td>{{$insumo->factura}}</td>
                                <td>
                                    @foreach ($insumo->lotes as $lote)

                                    {{$lote->fecha_vencimiento}} <br>
                                    @endforeach

                                </td>

                                <td>

                                    @can('insumo_update')
                                    <a class="btn btn-sm btn-primary" href="{{route('insumos.show', $insumo)}}"><i class="fa fa-eye" aria-hidden="true"></i> </a>
                                    @endcan

                                    @can('insumo_delte')
                                    <form action="{{route('insumos.destroy',   $insumo)}}" method="post" enctype="multipart/form">
                                        @csrf
                                        @method('DELETE')

                                        <button type="submit" class="btn btn-sm btn-danger" href="" onclick="return confirm('¿Esta Seguro de Eliminar?')"><i class="fa fa-trash" aria-hidden="true"></i> </button>
                                    </form>
                                    @endcan



                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection

@section('scripts')
<script src="{{asset('plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('plugins/datatable/js/dataTables.bootstrap4.min.js')}}"></script>

<script>
    $(document).ready(function() {
        $('#table_id').DataTable({
            "language": {
                'info': '_TOTAL_ Registros',
                'search': 'Buscar',
                'paginate': {
                    'next': 'siguiente',
                    'previous': 'atras'
                },
                'loadingRecords': 'cargando',
                'emptyTable': 'No hay datos',
                'zeroRecords': 'No hay datos iguales'
            }
        });
    });
</script>
@endsection