@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="row">
        <div class="col">
            <div class="card">
                <img class="card-img-top" src="holder.js/100x180/" alt="">
                <div class="card-body">
                    <h4 class="card-title">Crear Insumo</h4> <br>
                    <form action="{{ route('insumos.store') }}" method="POST">
                        @csrf

                        <div class="form-group">
                            <label for="nombre">Nombre del Insumo</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" required>
                        </div>

                        <div class="form-group">
                            <label for="precio">Precio</label>
                            <input type="number" name="precio" id="precio" class="form-control" step="0.01">
                        </div>

                        <div class="form-group">
                            <label for="minimo">Stock Mínimo</label>
                            <input type="number" name="minimo" id="minimo" class="form-control">
                        </div>

                        <h2>Lotes de Insumos</h2>

                        <table class="table" id="lotes-table">
                            <thead>
                                <tr>
                                    <th>Cantidad</th>
                                    <th>Fecha de Vencimiento</th>
                                    <th>Factura</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                        <button type="button" id="agregar-lote" class="btn btn-primary">Agregar Lote</button>

                        <button type="submit" class="btn btn-success">Guardar Insumo</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const agregarLoteBtn = document.getElementById('agregar-lote');
        const lotesTableBody = document.getElementById('lotes-table').querySelector('tbody');
        let loteCounter = 0;

        agregarLoteBtn.addEventListener('click', function() {
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
                <td><input type="number" class="form-control" name="lotes[${loteCounter}][cantidad]" required></td>
                <td><input type="date" class="form-control" name="lotes[${loteCounter}][fecha_vencimiento]"></td>
                <td><input type="text" class="form-control" name="lotes[${loteCounter}][factura]"></td>
                <td><button type="button" class="btn btn-danger btn-sm eliminar-lote">Eliminar</button></td>
            `;
            lotesTableBody.appendChild(newRow);
            loteCounter++;

            const eliminarLoteBtn = newRow.querySelector('.eliminar-lote');
            eliminarLoteBtn.addEventListener('click', function() {
                newRow.remove();
            });
        });


        // SOLUCIÓN PARA EVITAR DOBLE SUBMIT
        const form = document.querySelector('form'); // Selecciona tu formulario
        const submitButton = form.querySelector('button[type="submit"]');

        form.addEventListener('submit', function() {
            // Deshabilita el botón y cambia el texto para dar feedback
            if (submitButton) {
                submitButton.disabled = true;
                submitButton.textContent = 'Guardando...';
            }
        });

    });
</script>
@endsection
