<div class="card shadow-sm mb-4">
    {{-- Cabecera con color dinámico --}}
    <div class="card-header text-white d-flex justify-content-between align-items-center bg-{{ $color }}">
        <h5 class="mb-0">
            <i class="fa {{ $icono }} mr-2"></i> {{ $titulo }}
        </h5>
        <span class="badge badge-light text-dark">
            {{-- Contamos cuántos tratamientos tienen items pendientes --}}
            {{ $items->filter(fn($t) => $t->procedimientos->isNotEmpty())->count() }} Tratamientos
        </span>
    </div>

    <div class="card-body p-0">
        <div class="accordion" id="accordion-{{ $idUnico }}">

            @foreach ($items as $tratamiento)
            @if($tratamiento->procedimientos->isNotEmpty())

            <div class="card border-0 border-bottom">
                <div class="card-header bg-light" id="heading-{{ $idUnico }}-{{ $tratamiento->id }}">
                    <h2 class="mb-0">
                        <button class="btn btn-link btn-block text-left text-dark font-weight-bold text-decoration-none d-flex justify-content-between align-items-center"
                            type="button"
                            data-toggle="collapse"
                            data-target="#collapse-{{ $idUnico }}-{{ $tratamiento->id }}"
                            aria-expanded="false"
                            aria-controls="collapse-{{ $idUnico }}-{{ $tratamiento->id }}">

                            <span>
                                {{ $tratamiento->nombre }}
                            </span>

                            <span class="badge badge-{{ $color }} badge-pill">
                                {{ $tratamiento->procedimientos->count() }} Pendientes
                            </span>
                        </button>
                    </h2>
                </div>

                {{-- El ID del collapse debe ser único combinando el ID de sección y el del tratamiento --}}
                <div id="collapse-{{ $idUnico }}-{{ $tratamiento->id }}" class="collapse" data-parent="#accordion-{{ $idUnico }}">
                    <div class="card-body p-0">
                        <table class="table table-hover mb-0 table-sm">
                            <thead class="thead-light">
                                <tr>
                                    <th class="pl-4">Paciente</th>
                                    <th>Teléfono</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($tratamiento->procedimientos as $procedimiento)
                                <tr>
                                    <td class="pl-4 align-middle">
                                        {{ $procedimiento->paciente->nombre ?? 'Desconocido' }}
                                    </td>
                                    <td class="align-middle">
                                        {{ $procedimiento->paciente->telefono ?? '--' }}
                                    </td>
                                    <td class="text-center">
                                        {{-- WhatsApp --}}
                                        @if(isset($procedimiento->paciente->telefono))
                                        <a href="https://wa.me/502{{ $procedimiento->paciente->telefono }}?text=Hola {{ $procedimiento->paciente->nombre }}, le saludamos por su pendiente de {{ $tratamiento->nombre }}"
                                            target="_blank"
                                            class="btn btn-success btn-sm">
                                            <i class="fa fa-whatsapp"></i>
                                        </a>
                                        @endif
                                        {{-- Llamada --}}
                                        <a href="tel:{{ $procedimiento->paciente->telefono ?? '' }}" class="btn btn-secondary btn-sm">
                                            <i class="fa fa-phone"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            @endif
            @endforeach

            @if($items->isEmpty() || $items->every(fn($t) => $t->procedimientos->isEmpty()))
            <div class="p-3 text-center text-muted">
                <small>No hay pacientes pendientes en esta sección.</small>
            </div>
            @endif

        </div>
    </div>
</div>