@extends('layouts.admin')
@section('styles')
<link rel="stylesheet" href="{{asset('plugins/galeria/galeria.css')}}">
@endsection

@section('content')

<div class="container-fluid">
    <div class="row">
        <div class="col">

            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">{{$data->titulo}}</h4>
                    <p class="card-text">{{$data->descripcion}}</p>

                    <!-- Button trigger modal -->
                    <button type="button" class="btn btn-primary " data-toggle="modal" data-target="#modelId">
                        ACTUALIZAR DATOS
                    </button>

                    <!-- Modal -->
                    <div class="modal fade" id="modelId" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Modal title</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="{{route('fotos.update')}}" method="post">
                                    @csrf
                                    @method('PUT')

                                    <input type="hidden" value="{{$data->id}}" name="id" placeholder="">
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="titulo">Titulo</label>
                                                    <input type="text" class="form-control" name="titulo" id="titulo" placeholder="INGRESE EL TITULO" value="{{$data->titulo}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row ">
                                            <div class="col">
                                                <div class="form-group">
                                                    <label for="descripcion">Descripción</label>
                                                    <textarea class="form-control" name="descripcion" id="descripcion" rows="3">{{$data->descripcion}}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">CANCELAR</button>
                                        <button type="submit" class="btn btn-primary">GUARDAR</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="fotorama mt-4" data-allowfullscreen="true" data-width="50%" data-ratio="800/600" data-click="false" data-nav="thumbs">
                        <img style="width:20%" src="/storage/galeria/{{ $data->foto }}">
                        <img style="width:20%" src="/storage/galeria/{{ $data->foto2 }}">
                        <img style="width:20%" src="/storage/galeria/{{ $data->foto3 }}">
                        <img style="width:20%" src="/storage/galeria/{{ $data->foto4 }}">
                        <img style="width:20%" src="/storage/galeria/{{ $data->foto5 }}">
                    </div>


                </div>
            </div>


        </div>
    </div>
</div>

@endsection

@section('scripts')
<script src="{{asset('plugins/galeria/galeria.js')}}"></script>
@endsection