@extends('layouts.admin')



@section('content')
<div class="container-fluid mb-5">
    <div style="display: flex; justify-content: space-between; align-items: center;">

        <span id="card_title" style="font-size: 172%; color: black;">
            {{ __('Fotos') }}
        </span>

        <div class="float-right">
            <a href="{{ route('fotos.create') }}" class="btn btn-primary  float-right" data-placement="left">
                {{ __('Registrar Nueva Galería') }}
            </a>
        </div>
    </div>

    <div class="row">
        @foreach ($fotos as $foto)
        <div class="col-md-12 col-xl-4">
            <div class="card user-card p-4">
                <div class="card-header-img">
                    <img class="img-fluid img-radius" src="">
                    <h4>{{$foto->titulo}}</h4>

                    <h6>{{$foto->descripcion}}</h6>
                </div>



                <div>
                    <a href="{{route('fotos.show', ['id' => $foto->id])}}" class="btn btn-info waves-effect waves-light m-r-15"><i class="fa fa-eye" aria-hidden="true"></i></a>

                    <form action="{{route('fotos.delete', ['id' => $foto->id])}}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" onclick="return confirm('¿Estas Seguro de Eliminar?')" class="btn btn-danger waves-effect waves-light"><i class="fa fa-trash" aria-hidden="true"></i></button>
                    </form>
                </div>
            </div>
        </div>
        @endforeach
    </div>


</div>



@endsection